package zio.aws.securitylake
import zio.aws.securitylake.model.CreateDatalakeDelegatedAdminResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.securitylake.paginators.{
  ListSubscribersPublisher,
  GetDatalakeStatusPublisher,
  ListDatalakeExceptionsPublisher,
  ListLogSourcesPublisher
}
import software.amazon.awssdk.services.securitylake.model.{
  GetDatalakeExceptionsExpiryResponse,
  GetDatalakeExceptionsExpiryRequest,
  UpdateDatalakeResponse,
  DeleteDatalakeDelegatedAdminRequest,
  SubscriberResource,
  GetDatalakeRequest,
  CreateDatalakeDelegatedAdminResponse,
  DeleteAwsLogSourceRequest,
  DeleteSubscriptionNotificationConfigurationRequest,
  ListDatalakeExceptionsRequest,
  UpdateDatalakeExceptionsSubscriptionRequest,
  CreateSubscriberRequest,
  UpdateDatalakeRequest,
  CreateSubscriptionNotificationConfigurationResponse,
  DeleteDatalakeResponse,
  UpdateDatalakeExceptionsExpiryRequest,
  CreateDatalakeRequest,
  CreateDatalakeAutoEnableRequest,
  GetSubscriberResponse,
  CreateCustomLogSourceRequest,
  CreateDatalakeResponse,
  ListLogSourcesRequest,
  ListLogSourcesResponse,
  CreateCustomLogSourceResponse,
  GetDatalakeExceptionsSubscriptionResponse,
  CreateAwsLogSourceRequest,
  ListDatalakeExceptionsResponse,
  DeleteSubscriptionNotificationConfigurationResponse,
  UpdateSubscriberResponse,
  DeleteSubscriberRequest,
  AccountSources,
  DeleteCustomLogSourceResponse,
  DeleteDatalakeAutoEnableRequest,
  CreateSubscriberResponse,
  CreateDatalakeExceptionsSubscriptionResponse,
  GetDatalakeResponse,
  GetDatalakeExceptionsSubscriptionRequest,
  UpdateDatalakeExceptionsSubscriptionResponse,
  ListSubscribersResponse,
  DeleteDatalakeExceptionsSubscriptionResponse,
  UpdateSubscriberRequest,
  UpdateSubscriptionNotificationConfigurationResponse,
  DeleteDatalakeRequest,
  CreateDatalakeDelegatedAdminRequest,
  DeleteCustomLogSourceRequest,
  DeleteDatalakeDelegatedAdminResponse,
  DeleteDatalakeExceptionsSubscriptionRequest,
  FailuresResponse,
  CreateDatalakeAutoEnableResponse,
  CreateAwsLogSourceResponse,
  CreateSubscriptionNotificationConfigurationRequest,
  UpdateDatalakeExceptionsExpiryResponse,
  GetDatalakeStatusRequest,
  GetDatalakeAutoEnableRequest,
  GetDatalakeAutoEnableResponse,
  DeleteSubscriberResponse,
  UpdateSubscriptionNotificationConfigurationRequest,
  ListSubscribersRequest,
  DeleteDatalakeAutoEnableResponse,
  CreateDatalakeExceptionsSubscriptionRequest,
  GetSubscriberRequest,
  GetDatalakeStatusResponse,
  DeleteAwsLogSourceResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.securitylake.{
  SecurityLakeAsyncClientBuilder,
  SecurityLakeAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait SecurityLake extends AspectSupport[SecurityLake] {
  val api: SecurityLakeAsyncClient
  def updateDatalakeExceptionsSubscription(
      request: zio.aws.securitylake.model.UpdateDatalakeExceptionsSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.UpdateDatalakeExceptionsSubscriptionResponse.ReadOnly
  ]
  def deleteDatalake(
      request: zio.aws.securitylake.model.DeleteDatalakeRequest
  ): IO[AwsError, zio.aws.securitylake.model.DeleteDatalakeResponse.ReadOnly]
  def createSubscriptionNotificationConfiguration(
      request: zio.aws.securitylake.model.CreateSubscriptionNotificationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.CreateSubscriptionNotificationConfigurationResponse.ReadOnly
  ]
  def deleteSubscriber(
      request: zio.aws.securitylake.model.DeleteSubscriberRequest
  ): IO[AwsError, zio.aws.securitylake.model.DeleteSubscriberResponse.ReadOnly]
  def deleteDatalakeExceptionsSubscription(
      request: zio.aws.securitylake.model.DeleteDatalakeExceptionsSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse.ReadOnly
  ]
  def updateDatalake(
      request: zio.aws.securitylake.model.UpdateDatalakeRequest
  ): IO[AwsError, zio.aws.securitylake.model.UpdateDatalakeResponse.ReadOnly]
  def createDatalakeAutoEnable(
      request: zio.aws.securitylake.model.CreateDatalakeAutoEnableRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.CreateDatalakeAutoEnableResponse.ReadOnly
  ]
  def listLogSources(
      request: zio.aws.securitylake.model.ListLogSourcesRequest
  ): ZStream[Any, AwsError, Map[String, Map[String, List[String]]]]
  def listLogSourcesPaginated(
      request: zio.aws.securitylake.model.ListLogSourcesRequest
  ): IO[AwsError, zio.aws.securitylake.model.ListLogSourcesResponse.ReadOnly]
  def getDatalakeExceptionsSubscription(
      request: zio.aws.securitylake.model.GetDatalakeExceptionsSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.GetDatalakeExceptionsSubscriptionResponse.ReadOnly
  ]
  def getSubscriber(
      request: zio.aws.securitylake.model.GetSubscriberRequest
  ): IO[AwsError, zio.aws.securitylake.model.GetSubscriberResponse.ReadOnly]
  def deleteAwsLogSource(
      request: zio.aws.securitylake.model.DeleteAwsLogSourceRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.DeleteAwsLogSourceResponse.ReadOnly
  ]
  def updateSubscriber(
      request: zio.aws.securitylake.model.UpdateSubscriberRequest
  ): IO[AwsError, zio.aws.securitylake.model.UpdateSubscriberResponse.ReadOnly]
  def createCustomLogSource(
      request: zio.aws.securitylake.model.CreateCustomLogSourceRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.CreateCustomLogSourceResponse.ReadOnly
  ]
  def deleteSubscriptionNotificationConfiguration(
      request: zio.aws.securitylake.model.DeleteSubscriptionNotificationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.DeleteSubscriptionNotificationConfigurationResponse.ReadOnly
  ]
  def createDatalakeExceptionsSubscription(
      request: zio.aws.securitylake.model.CreateDatalakeExceptionsSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.CreateDatalakeExceptionsSubscriptionResponse.ReadOnly
  ]
  def listDatalakeExceptions(
      request: zio.aws.securitylake.model.ListDatalakeExceptionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.securitylake.model.FailuresResponse.ReadOnly
  ]
  def listDatalakeExceptionsPaginated(
      request: zio.aws.securitylake.model.ListDatalakeExceptionsRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.ListDatalakeExceptionsResponse.ReadOnly
  ]
  def createAwsLogSource(
      request: zio.aws.securitylake.model.CreateAwsLogSourceRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.CreateAwsLogSourceResponse.ReadOnly
  ]
  def getDatalakeStatus(
      request: zio.aws.securitylake.model.GetDatalakeStatusRequest
  ): ZStream[Any, AwsError, zio.aws.securitylake.model.AccountSources.ReadOnly]
  def getDatalakeStatusPaginated(
      request: zio.aws.securitylake.model.GetDatalakeStatusRequest
  ): IO[AwsError, zio.aws.securitylake.model.GetDatalakeStatusResponse.ReadOnly]
  def deleteCustomLogSource(
      request: zio.aws.securitylake.model.DeleteCustomLogSourceRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.DeleteCustomLogSourceResponse.ReadOnly
  ]
  def deleteDatalakeDelegatedAdmin(
      request: zio.aws.securitylake.model.DeleteDatalakeDelegatedAdminRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.DeleteDatalakeDelegatedAdminResponse.ReadOnly
  ]
  def createDatalake(
      request: zio.aws.securitylake.model.CreateDatalakeRequest
  ): IO[AwsError, zio.aws.securitylake.model.CreateDatalakeResponse.ReadOnly]
  def listSubscribers(
      request: zio.aws.securitylake.model.ListSubscribersRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.securitylake.model.SubscriberResource.ReadOnly
  ]
  def listSubscribersPaginated(
      request: zio.aws.securitylake.model.ListSubscribersRequest
  ): IO[AwsError, zio.aws.securitylake.model.ListSubscribersResponse.ReadOnly]
  def getDatalakeExceptionsExpiry(
      request: zio.aws.securitylake.model.GetDatalakeExceptionsExpiryRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.GetDatalakeExceptionsExpiryResponse.ReadOnly
  ]
  def createSubscriber(
      request: zio.aws.securitylake.model.CreateSubscriberRequest
  ): IO[AwsError, zio.aws.securitylake.model.CreateSubscriberResponse.ReadOnly]
  def getDatalake(
      request: zio.aws.securitylake.model.GetDatalakeRequest
  ): IO[AwsError, zio.aws.securitylake.model.GetDatalakeResponse.ReadOnly]
  def updateSubscriptionNotificationConfiguration(
      request: zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse.ReadOnly
  ]
  def getDatalakeAutoEnable(
      request: zio.aws.securitylake.model.GetDatalakeAutoEnableRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.GetDatalakeAutoEnableResponse.ReadOnly
  ]
  def updateDatalakeExceptionsExpiry(
      request: zio.aws.securitylake.model.UpdateDatalakeExceptionsExpiryRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.UpdateDatalakeExceptionsExpiryResponse.ReadOnly
  ]
  def createDatalakeDelegatedAdmin(
      request: zio.aws.securitylake.model.CreateDatalakeDelegatedAdminRequest
  ): IO[AwsError, ReadOnly]
  def deleteDatalakeAutoEnable(
      request: zio.aws.securitylake.model.DeleteDatalakeAutoEnableRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.DeleteDatalakeAutoEnableResponse.ReadOnly
  ]
}
object SecurityLake {
  val live: ZLayer[AwsConfig, java.lang.Throwable, SecurityLake] = customized(
    identity
  )
  def customized(
      customization: SecurityLakeAsyncClientBuilder => SecurityLakeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SecurityLake] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SecurityLakeAsyncClientBuilder => SecurityLakeAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, SecurityLake] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SecurityLakeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SecurityLakeAsyncClient, SecurityLakeAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      SecurityLakeAsyncClient,
      SecurityLakeAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new SecurityLakeImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class SecurityLakeImpl[R](
      override val api: SecurityLakeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SecurityLake
      with AwsServiceBase[R] {
    override val serviceName: String = "SecurityLake"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SecurityLakeImpl[R1] = new SecurityLakeImpl(api, newAspect, r)
    def updateDatalakeExceptionsSubscription(
        request: zio.aws.securitylake.model.UpdateDatalakeExceptionsSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.UpdateDatalakeExceptionsSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateDatalakeExceptionsSubscriptionRequest,
      UpdateDatalakeExceptionsSubscriptionResponse
    ](
      "updateDatalakeExceptionsSubscription",
      api.updateDatalakeExceptionsSubscription
    )(request.buildAwsValue())
      .map(
        zio.aws.securitylake.model.UpdateDatalakeExceptionsSubscriptionResponse.wrap
      )
      .provideEnvironment(r)
    def deleteDatalake(
        request: zio.aws.securitylake.model.DeleteDatalakeRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.DeleteDatalakeResponse.ReadOnly
    ] = asyncRequestResponse[DeleteDatalakeRequest, DeleteDatalakeResponse](
      "deleteDatalake",
      api.deleteDatalake
    )(request.buildAwsValue())
      .map(zio.aws.securitylake.model.DeleteDatalakeResponse.wrap)
      .provideEnvironment(r)
    def createSubscriptionNotificationConfiguration(
        request: zio.aws.securitylake.model.CreateSubscriptionNotificationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.CreateSubscriptionNotificationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateSubscriptionNotificationConfigurationRequest,
      CreateSubscriptionNotificationConfigurationResponse
    ](
      "createSubscriptionNotificationConfiguration",
      api.createSubscriptionNotificationConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.securitylake.model.CreateSubscriptionNotificationConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def deleteSubscriber(
        request: zio.aws.securitylake.model.DeleteSubscriberRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.DeleteSubscriberResponse.ReadOnly
    ] = asyncRequestResponse[DeleteSubscriberRequest, DeleteSubscriberResponse](
      "deleteSubscriber",
      api.deleteSubscriber
    )(request.buildAwsValue())
      .map(zio.aws.securitylake.model.DeleteSubscriberResponse.wrap)
      .provideEnvironment(r)
    def deleteDatalakeExceptionsSubscription(
        request: zio.aws.securitylake.model.DeleteDatalakeExceptionsSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDatalakeExceptionsSubscriptionRequest,
      DeleteDatalakeExceptionsSubscriptionResponse
    ](
      "deleteDatalakeExceptionsSubscription",
      api.deleteDatalakeExceptionsSubscription
    )(request.buildAwsValue())
      .map(
        zio.aws.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse.wrap
      )
      .provideEnvironment(r)
    def updateDatalake(
        request: zio.aws.securitylake.model.UpdateDatalakeRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.UpdateDatalakeResponse.ReadOnly
    ] = asyncRequestResponse[UpdateDatalakeRequest, UpdateDatalakeResponse](
      "updateDatalake",
      api.updateDatalake
    )(request.buildAwsValue())
      .map(zio.aws.securitylake.model.UpdateDatalakeResponse.wrap)
      .provideEnvironment(r)
    def createDatalakeAutoEnable(
        request: zio.aws.securitylake.model.CreateDatalakeAutoEnableRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.CreateDatalakeAutoEnableResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDatalakeAutoEnableRequest,
      CreateDatalakeAutoEnableResponse
    ]("createDatalakeAutoEnable", api.createDatalakeAutoEnable)(
      request.buildAwsValue()
    ).map(zio.aws.securitylake.model.CreateDatalakeAutoEnableResponse.wrap)
      .provideEnvironment(r)
    def listLogSources(
        request: zio.aws.securitylake.model.ListLogSourcesRequest
    ): ZStream[Any, AwsError, Map[String, Map[String, List[String]]]] =
      asyncJavaPaginatedRequest[ListLogSourcesRequest, java.util.Map[
        java.lang.String,
        java.util.Map[java.lang.String, java.util.List[java.lang.String]]
      ], ListLogSourcesPublisher](
        "listLogSources",
        api.listLogSourcesPaginator,
        _.regionSourceTypesAccountsList()
      )(request.buildAwsValue())
        .map(item =>
          item.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala
                .map({ case (key, value) =>
                  (key: String) -> value.asScala.map { item =>
                    item: String
                  }.toList
                })
                .toMap
            })
            .toMap
        )
        .provideEnvironment(r)
    def listLogSourcesPaginated(
        request: zio.aws.securitylake.model.ListLogSourcesRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.ListLogSourcesResponse.ReadOnly
    ] = asyncRequestResponse[ListLogSourcesRequest, ListLogSourcesResponse](
      "listLogSources",
      api.listLogSources
    )(request.buildAwsValue())
      .map(zio.aws.securitylake.model.ListLogSourcesResponse.wrap)
      .provideEnvironment(r)
    def getDatalakeExceptionsSubscription(
        request: zio.aws.securitylake.model.GetDatalakeExceptionsSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.GetDatalakeExceptionsSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDatalakeExceptionsSubscriptionRequest,
      GetDatalakeExceptionsSubscriptionResponse
    ](
      "getDatalakeExceptionsSubscription",
      api.getDatalakeExceptionsSubscription
    )(request.buildAwsValue())
      .map(
        zio.aws.securitylake.model.GetDatalakeExceptionsSubscriptionResponse.wrap
      )
      .provideEnvironment(r)
    def getSubscriber(
        request: zio.aws.securitylake.model.GetSubscriberRequest
    ): IO[AwsError, zio.aws.securitylake.model.GetSubscriberResponse.ReadOnly] =
      asyncRequestResponse[GetSubscriberRequest, GetSubscriberResponse](
        "getSubscriber",
        api.getSubscriber
      )(request.buildAwsValue())
        .map(zio.aws.securitylake.model.GetSubscriberResponse.wrap)
        .provideEnvironment(r)
    def deleteAwsLogSource(
        request: zio.aws.securitylake.model.DeleteAwsLogSourceRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.DeleteAwsLogSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteAwsLogSourceRequest,
      DeleteAwsLogSourceResponse
    ]("deleteAwsLogSource", api.deleteAwsLogSource)(request.buildAwsValue())
      .map(zio.aws.securitylake.model.DeleteAwsLogSourceResponse.wrap)
      .provideEnvironment(r)
    def updateSubscriber(
        request: zio.aws.securitylake.model.UpdateSubscriberRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.UpdateSubscriberResponse.ReadOnly
    ] = asyncRequestResponse[UpdateSubscriberRequest, UpdateSubscriberResponse](
      "updateSubscriber",
      api.updateSubscriber
    )(request.buildAwsValue())
      .map(zio.aws.securitylake.model.UpdateSubscriberResponse.wrap)
      .provideEnvironment(r)
    def createCustomLogSource(
        request: zio.aws.securitylake.model.CreateCustomLogSourceRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.CreateCustomLogSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateCustomLogSourceRequest,
      CreateCustomLogSourceResponse
    ]("createCustomLogSource", api.createCustomLogSource)(
      request.buildAwsValue()
    ).map(zio.aws.securitylake.model.CreateCustomLogSourceResponse.wrap)
      .provideEnvironment(r)
    def deleteSubscriptionNotificationConfiguration(
        request: zio.aws.securitylake.model.DeleteSubscriptionNotificationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.DeleteSubscriptionNotificationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteSubscriptionNotificationConfigurationRequest,
      DeleteSubscriptionNotificationConfigurationResponse
    ](
      "deleteSubscriptionNotificationConfiguration",
      api.deleteSubscriptionNotificationConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.securitylake.model.DeleteSubscriptionNotificationConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def createDatalakeExceptionsSubscription(
        request: zio.aws.securitylake.model.CreateDatalakeExceptionsSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.CreateDatalakeExceptionsSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDatalakeExceptionsSubscriptionRequest,
      CreateDatalakeExceptionsSubscriptionResponse
    ](
      "createDatalakeExceptionsSubscription",
      api.createDatalakeExceptionsSubscription
    )(request.buildAwsValue())
      .map(
        zio.aws.securitylake.model.CreateDatalakeExceptionsSubscriptionResponse.wrap
      )
      .provideEnvironment(r)
    def listDatalakeExceptions(
        request: zio.aws.securitylake.model.ListDatalakeExceptionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.securitylake.model.FailuresResponse.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListDatalakeExceptionsRequest,
      FailuresResponse,
      ListDatalakeExceptionsPublisher
    ](
      "listDatalakeExceptions",
      api.listDatalakeExceptionsPaginator,
      _.nonRetryableFailures()
    )(request.buildAwsValue())
      .map(item => zio.aws.securitylake.model.FailuresResponse.wrap(item))
      .provideEnvironment(r)
    def listDatalakeExceptionsPaginated(
        request: zio.aws.securitylake.model.ListDatalakeExceptionsRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.ListDatalakeExceptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDatalakeExceptionsRequest,
      ListDatalakeExceptionsResponse
    ]("listDatalakeExceptions", api.listDatalakeExceptions)(
      request.buildAwsValue()
    ).map(zio.aws.securitylake.model.ListDatalakeExceptionsResponse.wrap)
      .provideEnvironment(r)
    def createAwsLogSource(
        request: zio.aws.securitylake.model.CreateAwsLogSourceRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.CreateAwsLogSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateAwsLogSourceRequest,
      CreateAwsLogSourceResponse
    ]("createAwsLogSource", api.createAwsLogSource)(request.buildAwsValue())
      .map(zio.aws.securitylake.model.CreateAwsLogSourceResponse.wrap)
      .provideEnvironment(r)
    def getDatalakeStatus(
        request: zio.aws.securitylake.model.GetDatalakeStatusRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.securitylake.model.AccountSources.ReadOnly
    ] = asyncJavaPaginatedRequest[
      GetDatalakeStatusRequest,
      AccountSources,
      GetDatalakeStatusPublisher
    ](
      "getDatalakeStatus",
      api.getDatalakeStatusPaginator,
      _.accountSourcesList()
    )(request.buildAwsValue())
      .map(item => zio.aws.securitylake.model.AccountSources.wrap(item))
      .provideEnvironment(r)
    def getDatalakeStatusPaginated(
        request: zio.aws.securitylake.model.GetDatalakeStatusRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.GetDatalakeStatusResponse.ReadOnly
    ] =
      asyncRequestResponse[GetDatalakeStatusRequest, GetDatalakeStatusResponse](
        "getDatalakeStatus",
        api.getDatalakeStatus
      )(request.buildAwsValue())
        .map(zio.aws.securitylake.model.GetDatalakeStatusResponse.wrap)
        .provideEnvironment(r)
    def deleteCustomLogSource(
        request: zio.aws.securitylake.model.DeleteCustomLogSourceRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.DeleteCustomLogSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteCustomLogSourceRequest,
      DeleteCustomLogSourceResponse
    ]("deleteCustomLogSource", api.deleteCustomLogSource)(
      request.buildAwsValue()
    ).map(zio.aws.securitylake.model.DeleteCustomLogSourceResponse.wrap)
      .provideEnvironment(r)
    def deleteDatalakeDelegatedAdmin(
        request: zio.aws.securitylake.model.DeleteDatalakeDelegatedAdminRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.DeleteDatalakeDelegatedAdminResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDatalakeDelegatedAdminRequest,
      DeleteDatalakeDelegatedAdminResponse
    ]("deleteDatalakeDelegatedAdmin", api.deleteDatalakeDelegatedAdmin)(
      request.buildAwsValue()
    ).map(zio.aws.securitylake.model.DeleteDatalakeDelegatedAdminResponse.wrap)
      .provideEnvironment(r)
    def createDatalake(
        request: zio.aws.securitylake.model.CreateDatalakeRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.CreateDatalakeResponse.ReadOnly
    ] = asyncRequestResponse[CreateDatalakeRequest, CreateDatalakeResponse](
      "createDatalake",
      api.createDatalake
    )(request.buildAwsValue())
      .map(zio.aws.securitylake.model.CreateDatalakeResponse.wrap)
      .provideEnvironment(r)
    def listSubscribers(
        request: zio.aws.securitylake.model.ListSubscribersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.securitylake.model.SubscriberResource.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListSubscribersRequest,
      SubscriberResource,
      ListSubscribersPublisher
    ]("listSubscribers", api.listSubscribersPaginator, _.subscribers())(
      request.buildAwsValue()
    ).map(item => zio.aws.securitylake.model.SubscriberResource.wrap(item))
      .provideEnvironment(r)
    def listSubscribersPaginated(
        request: zio.aws.securitylake.model.ListSubscribersRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.ListSubscribersResponse.ReadOnly
    ] = asyncRequestResponse[ListSubscribersRequest, ListSubscribersResponse](
      "listSubscribers",
      api.listSubscribers
    )(request.buildAwsValue())
      .map(zio.aws.securitylake.model.ListSubscribersResponse.wrap)
      .provideEnvironment(r)
    def getDatalakeExceptionsExpiry(
        request: zio.aws.securitylake.model.GetDatalakeExceptionsExpiryRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.GetDatalakeExceptionsExpiryResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDatalakeExceptionsExpiryRequest,
      GetDatalakeExceptionsExpiryResponse
    ]("getDatalakeExceptionsExpiry", api.getDatalakeExceptionsExpiry)(
      request.buildAwsValue()
    ).map(zio.aws.securitylake.model.GetDatalakeExceptionsExpiryResponse.wrap)
      .provideEnvironment(r)
    def createSubscriber(
        request: zio.aws.securitylake.model.CreateSubscriberRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.CreateSubscriberResponse.ReadOnly
    ] = asyncRequestResponse[CreateSubscriberRequest, CreateSubscriberResponse](
      "createSubscriber",
      api.createSubscriber
    )(request.buildAwsValue())
      .map(zio.aws.securitylake.model.CreateSubscriberResponse.wrap)
      .provideEnvironment(r)
    def getDatalake(
        request: zio.aws.securitylake.model.GetDatalakeRequest
    ): IO[AwsError, zio.aws.securitylake.model.GetDatalakeResponse.ReadOnly] =
      asyncRequestResponse[GetDatalakeRequest, GetDatalakeResponse](
        "getDatalake",
        api.getDatalake
      )(request.buildAwsValue())
        .map(zio.aws.securitylake.model.GetDatalakeResponse.wrap)
        .provideEnvironment(r)
    def updateSubscriptionNotificationConfiguration(
        request: zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSubscriptionNotificationConfigurationRequest,
      UpdateSubscriptionNotificationConfigurationResponse
    ](
      "updateSubscriptionNotificationConfiguration",
      api.updateSubscriptionNotificationConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def getDatalakeAutoEnable(
        request: zio.aws.securitylake.model.GetDatalakeAutoEnableRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.GetDatalakeAutoEnableResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDatalakeAutoEnableRequest,
      GetDatalakeAutoEnableResponse
    ]("getDatalakeAutoEnable", api.getDatalakeAutoEnable)(
      request.buildAwsValue()
    ).map(zio.aws.securitylake.model.GetDatalakeAutoEnableResponse.wrap)
      .provideEnvironment(r)
    def updateDatalakeExceptionsExpiry(
        request: zio.aws.securitylake.model.UpdateDatalakeExceptionsExpiryRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.UpdateDatalakeExceptionsExpiryResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateDatalakeExceptionsExpiryRequest,
      UpdateDatalakeExceptionsExpiryResponse
    ]("updateDatalakeExceptionsExpiry", api.updateDatalakeExceptionsExpiry)(
      request.buildAwsValue()
    ).map(
      zio.aws.securitylake.model.UpdateDatalakeExceptionsExpiryResponse.wrap
    ).provideEnvironment(r)
    def createDatalakeDelegatedAdmin(
        request: zio.aws.securitylake.model.CreateDatalakeDelegatedAdminRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      CreateDatalakeDelegatedAdminRequest,
      CreateDatalakeDelegatedAdminResponse
    ]("createDatalakeDelegatedAdmin", api.createDatalakeDelegatedAdmin)(
      request.buildAwsValue()
    ).map(zio.aws.securitylake.model.CreateDatalakeDelegatedAdminResponse.wrap)
      .provideEnvironment(r)
    def deleteDatalakeAutoEnable(
        request: zio.aws.securitylake.model.DeleteDatalakeAutoEnableRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.DeleteDatalakeAutoEnableResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDatalakeAutoEnableRequest,
      DeleteDatalakeAutoEnableResponse
    ]("deleteDatalakeAutoEnable", api.deleteDatalakeAutoEnable)(
      request.buildAwsValue()
    ).map(zio.aws.securitylake.model.DeleteDatalakeAutoEnableResponse.wrap)
      .provideEnvironment(r)
  }
  def updateDatalakeExceptionsSubscription(
      request: zio.aws.securitylake.model.UpdateDatalakeExceptionsSubscriptionRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.UpdateDatalakeExceptionsSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDatalakeExceptionsSubscription(request))
  def deleteDatalake(
      request: zio.aws.securitylake.model.DeleteDatalakeRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DeleteDatalakeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDatalake(request))
  def createSubscriptionNotificationConfiguration(
      request: zio.aws.securitylake.model.CreateSubscriptionNotificationConfigurationRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.CreateSubscriptionNotificationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSubscriptionNotificationConfiguration(request))
  def deleteSubscriber(
      request: zio.aws.securitylake.model.DeleteSubscriberRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DeleteSubscriberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSubscriber(request))
  def deleteDatalakeExceptionsSubscription(
      request: zio.aws.securitylake.model.DeleteDatalakeExceptionsSubscriptionRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDatalakeExceptionsSubscription(request))
  def updateDatalake(
      request: zio.aws.securitylake.model.UpdateDatalakeRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.UpdateDatalakeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDatalake(request))
  def createDatalakeAutoEnable(
      request: zio.aws.securitylake.model.CreateDatalakeAutoEnableRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.CreateDatalakeAutoEnableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDatalakeAutoEnable(request))
  def listLogSources(
      request: zio.aws.securitylake.model.ListLogSourcesRequest
  ): ZStream[zio.aws.securitylake.SecurityLake, AwsError, Map[
    String,
    Map[String, List[String]]
  ]] = ZStream.serviceWithStream(_.listLogSources(request))
  def listLogSourcesPaginated(
      request: zio.aws.securitylake.model.ListLogSourcesRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.ListLogSourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLogSourcesPaginated(request))
  def getDatalakeExceptionsSubscription(
      request: zio.aws.securitylake.model.GetDatalakeExceptionsSubscriptionRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.GetDatalakeExceptionsSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDatalakeExceptionsSubscription(request))
  def getSubscriber(
      request: zio.aws.securitylake.model.GetSubscriberRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.GetSubscriberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSubscriber(request))
  def deleteAwsLogSource(
      request: zio.aws.securitylake.model.DeleteAwsLogSourceRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DeleteAwsLogSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAwsLogSource(request))
  def updateSubscriber(
      request: zio.aws.securitylake.model.UpdateSubscriberRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.UpdateSubscriberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSubscriber(request))
  def createCustomLogSource(
      request: zio.aws.securitylake.model.CreateCustomLogSourceRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.CreateCustomLogSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCustomLogSource(request))
  def deleteSubscriptionNotificationConfiguration(
      request: zio.aws.securitylake.model.DeleteSubscriptionNotificationConfigurationRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DeleteSubscriptionNotificationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSubscriptionNotificationConfiguration(request))
  def createDatalakeExceptionsSubscription(
      request: zio.aws.securitylake.model.CreateDatalakeExceptionsSubscriptionRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.CreateDatalakeExceptionsSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDatalakeExceptionsSubscription(request))
  def listDatalakeExceptions(
      request: zio.aws.securitylake.model.ListDatalakeExceptionsRequest
  ): ZStream[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.FailuresResponse.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatalakeExceptions(request))
  def listDatalakeExceptionsPaginated(
      request: zio.aws.securitylake.model.ListDatalakeExceptionsRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.ListDatalakeExceptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatalakeExceptionsPaginated(request))
  def createAwsLogSource(
      request: zio.aws.securitylake.model.CreateAwsLogSourceRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.CreateAwsLogSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAwsLogSource(request))
  def getDatalakeStatus(
      request: zio.aws.securitylake.model.GetDatalakeStatusRequest
  ): ZStream[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.AccountSources.ReadOnly
  ] = ZStream.serviceWithStream(_.getDatalakeStatus(request))
  def getDatalakeStatusPaginated(
      request: zio.aws.securitylake.model.GetDatalakeStatusRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.GetDatalakeStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDatalakeStatusPaginated(request))
  def deleteCustomLogSource(
      request: zio.aws.securitylake.model.DeleteCustomLogSourceRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DeleteCustomLogSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCustomLogSource(request))
  def deleteDatalakeDelegatedAdmin(
      request: zio.aws.securitylake.model.DeleteDatalakeDelegatedAdminRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DeleteDatalakeDelegatedAdminResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDatalakeDelegatedAdmin(request))
  def createDatalake(
      request: zio.aws.securitylake.model.CreateDatalakeRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.CreateDatalakeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDatalake(request))
  def listSubscribers(
      request: zio.aws.securitylake.model.ListSubscribersRequest
  ): ZStream[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.SubscriberResource.ReadOnly
  ] = ZStream.serviceWithStream(_.listSubscribers(request))
  def listSubscribersPaginated(
      request: zio.aws.securitylake.model.ListSubscribersRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.ListSubscribersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSubscribersPaginated(request))
  def getDatalakeExceptionsExpiry(
      request: zio.aws.securitylake.model.GetDatalakeExceptionsExpiryRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.GetDatalakeExceptionsExpiryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDatalakeExceptionsExpiry(request))
  def createSubscriber(
      request: zio.aws.securitylake.model.CreateSubscriberRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.CreateSubscriberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSubscriber(request))
  def getDatalake(request: zio.aws.securitylake.model.GetDatalakeRequest): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.GetDatalakeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDatalake(request))
  def updateSubscriptionNotificationConfiguration(
      request: zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSubscriptionNotificationConfiguration(request))
  def getDatalakeAutoEnable(
      request: zio.aws.securitylake.model.GetDatalakeAutoEnableRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.GetDatalakeAutoEnableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDatalakeAutoEnable(request))
  def updateDatalakeExceptionsExpiry(
      request: zio.aws.securitylake.model.UpdateDatalakeExceptionsExpiryRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.UpdateDatalakeExceptionsExpiryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDatalakeExceptionsExpiry(request))
  def createDatalakeDelegatedAdmin(
      request: zio.aws.securitylake.model.CreateDatalakeDelegatedAdminRequest
  ): ZIO[zio.aws.securitylake.SecurityLake, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createDatalakeDelegatedAdmin(request))
  def deleteDatalakeAutoEnable(
      request: zio.aws.securitylake.model.DeleteDatalakeAutoEnableRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DeleteDatalakeAutoEnableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDatalakeAutoEnable(request))
}
