package zio.aws.securitylake
import zio.aws.securitylake.model.CreateDatalakeDelegatedAdminResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.securitylake.SecurityLakeAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.securitylake.model.{
  GetDatalakeExceptionsExpiryRequest,
  DeleteDatalakeDelegatedAdminRequest,
  GetDatalakeRequest,
  DeleteAwsLogSourceRequest,
  DeleteSubscriptionNotificationConfigurationRequest,
  ListDatalakeExceptionsRequest,
  UpdateDatalakeExceptionsSubscriptionRequest,
  CreateSubscriberRequest,
  UpdateDatalakeRequest,
  UpdateDatalakeExceptionsExpiryRequest,
  CreateDatalakeRequest,
  CreateDatalakeAutoEnableRequest,
  CreateCustomLogSourceRequest,
  ListLogSourcesRequest,
  CreateAwsLogSourceRequest,
  DeleteSubscriberRequest,
  DeleteDatalakeAutoEnableRequest,
  GetDatalakeExceptionsSubscriptionRequest,
  UpdateSubscriberRequest,
  DeleteDatalakeRequest,
  CreateDatalakeDelegatedAdminRequest,
  DeleteCustomLogSourceRequest,
  DeleteDatalakeExceptionsSubscriptionRequest,
  CreateSubscriptionNotificationConfigurationRequest,
  GetDatalakeStatusRequest,
  GetDatalakeAutoEnableRequest,
  UpdateSubscriptionNotificationConfigurationRequest,
  ListSubscribersRequest,
  CreateDatalakeExceptionsSubscriptionRequest,
  GetSubscriberRequest
}
object SecurityLakeMock extends Mock[SecurityLake] {
  object UpdateDatalakeExceptionsSubscription
      extends Effect[
        UpdateDatalakeExceptionsSubscriptionRequest,
        AwsError,
        zio.aws.securitylake.model.UpdateDatalakeExceptionsSubscriptionResponse.ReadOnly
      ]
  object DeleteDatalake
      extends Effect[
        DeleteDatalakeRequest,
        AwsError,
        zio.aws.securitylake.model.DeleteDatalakeResponse.ReadOnly
      ]
  object CreateSubscriptionNotificationConfiguration
      extends Effect[
        CreateSubscriptionNotificationConfigurationRequest,
        AwsError,
        zio.aws.securitylake.model.CreateSubscriptionNotificationConfigurationResponse.ReadOnly
      ]
  object DeleteSubscriber
      extends Effect[
        DeleteSubscriberRequest,
        AwsError,
        zio.aws.securitylake.model.DeleteSubscriberResponse.ReadOnly
      ]
  object DeleteDatalakeExceptionsSubscription
      extends Effect[
        DeleteDatalakeExceptionsSubscriptionRequest,
        AwsError,
        zio.aws.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse.ReadOnly
      ]
  object UpdateDatalake
      extends Effect[
        UpdateDatalakeRequest,
        AwsError,
        zio.aws.securitylake.model.UpdateDatalakeResponse.ReadOnly
      ]
  object CreateDatalakeAutoEnable
      extends Effect[
        CreateDatalakeAutoEnableRequest,
        AwsError,
        zio.aws.securitylake.model.CreateDatalakeAutoEnableResponse.ReadOnly
      ]
  object ListLogSources
      extends Stream[
        ListLogSourcesRequest,
        AwsError,
        Map[String, Map[String, List[String]]]
      ]
  object ListLogSourcesPaginated
      extends Effect[
        ListLogSourcesRequest,
        AwsError,
        zio.aws.securitylake.model.ListLogSourcesResponse.ReadOnly
      ]
  object GetDatalakeExceptionsSubscription
      extends Effect[
        GetDatalakeExceptionsSubscriptionRequest,
        AwsError,
        zio.aws.securitylake.model.GetDatalakeExceptionsSubscriptionResponse.ReadOnly
      ]
  object GetSubscriber
      extends Effect[
        GetSubscriberRequest,
        AwsError,
        zio.aws.securitylake.model.GetSubscriberResponse.ReadOnly
      ]
  object DeleteAwsLogSource
      extends Effect[
        DeleteAwsLogSourceRequest,
        AwsError,
        zio.aws.securitylake.model.DeleteAwsLogSourceResponse.ReadOnly
      ]
  object UpdateSubscriber
      extends Effect[
        UpdateSubscriberRequest,
        AwsError,
        zio.aws.securitylake.model.UpdateSubscriberResponse.ReadOnly
      ]
  object CreateCustomLogSource
      extends Effect[
        CreateCustomLogSourceRequest,
        AwsError,
        zio.aws.securitylake.model.CreateCustomLogSourceResponse.ReadOnly
      ]
  object DeleteSubscriptionNotificationConfiguration
      extends Effect[
        DeleteSubscriptionNotificationConfigurationRequest,
        AwsError,
        zio.aws.securitylake.model.DeleteSubscriptionNotificationConfigurationResponse.ReadOnly
      ]
  object CreateDatalakeExceptionsSubscription
      extends Effect[
        CreateDatalakeExceptionsSubscriptionRequest,
        AwsError,
        zio.aws.securitylake.model.CreateDatalakeExceptionsSubscriptionResponse.ReadOnly
      ]
  object ListDatalakeExceptions
      extends Stream[
        ListDatalakeExceptionsRequest,
        AwsError,
        zio.aws.securitylake.model.FailuresResponse.ReadOnly
      ]
  object ListDatalakeExceptionsPaginated
      extends Effect[
        ListDatalakeExceptionsRequest,
        AwsError,
        zio.aws.securitylake.model.ListDatalakeExceptionsResponse.ReadOnly
      ]
  object CreateAwsLogSource
      extends Effect[
        CreateAwsLogSourceRequest,
        AwsError,
        zio.aws.securitylake.model.CreateAwsLogSourceResponse.ReadOnly
      ]
  object GetDatalakeStatus
      extends Stream[
        GetDatalakeStatusRequest,
        AwsError,
        zio.aws.securitylake.model.AccountSources.ReadOnly
      ]
  object GetDatalakeStatusPaginated
      extends Effect[
        GetDatalakeStatusRequest,
        AwsError,
        zio.aws.securitylake.model.GetDatalakeStatusResponse.ReadOnly
      ]
  object DeleteCustomLogSource
      extends Effect[
        DeleteCustomLogSourceRequest,
        AwsError,
        zio.aws.securitylake.model.DeleteCustomLogSourceResponse.ReadOnly
      ]
  object DeleteDatalakeDelegatedAdmin
      extends Effect[
        DeleteDatalakeDelegatedAdminRequest,
        AwsError,
        zio.aws.securitylake.model.DeleteDatalakeDelegatedAdminResponse.ReadOnly
      ]
  object CreateDatalake
      extends Effect[
        CreateDatalakeRequest,
        AwsError,
        zio.aws.securitylake.model.CreateDatalakeResponse.ReadOnly
      ]
  object ListSubscribers
      extends Stream[
        ListSubscribersRequest,
        AwsError,
        zio.aws.securitylake.model.SubscriberResource.ReadOnly
      ]
  object ListSubscribersPaginated
      extends Effect[
        ListSubscribersRequest,
        AwsError,
        zio.aws.securitylake.model.ListSubscribersResponse.ReadOnly
      ]
  object GetDatalakeExceptionsExpiry
      extends Effect[
        GetDatalakeExceptionsExpiryRequest,
        AwsError,
        zio.aws.securitylake.model.GetDatalakeExceptionsExpiryResponse.ReadOnly
      ]
  object CreateSubscriber
      extends Effect[
        CreateSubscriberRequest,
        AwsError,
        zio.aws.securitylake.model.CreateSubscriberResponse.ReadOnly
      ]
  object GetDatalake
      extends Effect[
        GetDatalakeRequest,
        AwsError,
        zio.aws.securitylake.model.GetDatalakeResponse.ReadOnly
      ]
  object UpdateSubscriptionNotificationConfiguration
      extends Effect[
        UpdateSubscriptionNotificationConfigurationRequest,
        AwsError,
        zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse.ReadOnly
      ]
  object GetDatalakeAutoEnable
      extends Effect[
        GetDatalakeAutoEnableRequest,
        AwsError,
        zio.aws.securitylake.model.GetDatalakeAutoEnableResponse.ReadOnly
      ]
  object UpdateDatalakeExceptionsExpiry
      extends Effect[
        UpdateDatalakeExceptionsExpiryRequest,
        AwsError,
        zio.aws.securitylake.model.UpdateDatalakeExceptionsExpiryResponse.ReadOnly
      ]
  object CreateDatalakeDelegatedAdmin
      extends Effect[CreateDatalakeDelegatedAdminRequest, AwsError, ReadOnly]
  object DeleteDatalakeAutoEnable
      extends Effect[
        DeleteDatalakeAutoEnableRequest,
        AwsError,
        zio.aws.securitylake.model.DeleteDatalakeAutoEnableResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, SecurityLake] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, SecurityLake] { rts =>
        zio.ZIO.succeed {
          new SecurityLake {
            val api: SecurityLakeAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): SecurityLake = this
            def updateDatalakeExceptionsSubscription(
                request: UpdateDatalakeExceptionsSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.UpdateDatalakeExceptionsSubscriptionResponse.ReadOnly
            ] = proxy(UpdateDatalakeExceptionsSubscription, request)
            def deleteDatalake(request: DeleteDatalakeRequest): IO[
              AwsError,
              zio.aws.securitylake.model.DeleteDatalakeResponse.ReadOnly
            ] = proxy(DeleteDatalake, request)
            def createSubscriptionNotificationConfiguration(
                request: CreateSubscriptionNotificationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.CreateSubscriptionNotificationConfigurationResponse.ReadOnly
            ] = proxy(CreateSubscriptionNotificationConfiguration, request)
            def deleteSubscriber(request: DeleteSubscriberRequest): IO[
              AwsError,
              zio.aws.securitylake.model.DeleteSubscriberResponse.ReadOnly
            ] = proxy(DeleteSubscriber, request)
            def deleteDatalakeExceptionsSubscription(
                request: DeleteDatalakeExceptionsSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse.ReadOnly
            ] = proxy(DeleteDatalakeExceptionsSubscription, request)
            def updateDatalake(request: UpdateDatalakeRequest): IO[
              AwsError,
              zio.aws.securitylake.model.UpdateDatalakeResponse.ReadOnly
            ] = proxy(UpdateDatalake, request)
            def createDatalakeAutoEnable(
                request: CreateDatalakeAutoEnableRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.CreateDatalakeAutoEnableResponse.ReadOnly
            ] = proxy(CreateDatalakeAutoEnable, request)
            def listLogSources(
                request: ListLogSourcesRequest
            ): ZStream[Any, AwsError, Map[String, Map[String, List[String]]]] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListLogSources, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listLogSourcesPaginated(request: ListLogSourcesRequest): IO[
              AwsError,
              zio.aws.securitylake.model.ListLogSourcesResponse.ReadOnly
            ] = proxy(ListLogSourcesPaginated, request)
            def getDatalakeExceptionsSubscription(
                request: GetDatalakeExceptionsSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.GetDatalakeExceptionsSubscriptionResponse.ReadOnly
            ] = proxy(GetDatalakeExceptionsSubscription, request)
            def getSubscriber(request: GetSubscriberRequest): IO[
              AwsError,
              zio.aws.securitylake.model.GetSubscriberResponse.ReadOnly
            ] = proxy(GetSubscriber, request)
            def deleteAwsLogSource(request: DeleteAwsLogSourceRequest): IO[
              AwsError,
              zio.aws.securitylake.model.DeleteAwsLogSourceResponse.ReadOnly
            ] = proxy(DeleteAwsLogSource, request)
            def updateSubscriber(request: UpdateSubscriberRequest): IO[
              AwsError,
              zio.aws.securitylake.model.UpdateSubscriberResponse.ReadOnly
            ] = proxy(UpdateSubscriber, request)
            def createCustomLogSource(
                request: CreateCustomLogSourceRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.CreateCustomLogSourceResponse.ReadOnly
            ] = proxy(CreateCustomLogSource, request)
            def deleteSubscriptionNotificationConfiguration(
                request: DeleteSubscriptionNotificationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.DeleteSubscriptionNotificationConfigurationResponse.ReadOnly
            ] = proxy(DeleteSubscriptionNotificationConfiguration, request)
            def createDatalakeExceptionsSubscription(
                request: CreateDatalakeExceptionsSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.CreateDatalakeExceptionsSubscriptionResponse.ReadOnly
            ] = proxy(CreateDatalakeExceptionsSubscription, request)
            def listDatalakeExceptions(
                request: ListDatalakeExceptionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.securitylake.model.FailuresResponse.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDatalakeExceptions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDatalakeExceptionsPaginated(
                request: ListDatalakeExceptionsRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.ListDatalakeExceptionsResponse.ReadOnly
            ] = proxy(ListDatalakeExceptionsPaginated, request)
            def createAwsLogSource(request: CreateAwsLogSourceRequest): IO[
              AwsError,
              zio.aws.securitylake.model.CreateAwsLogSourceResponse.ReadOnly
            ] = proxy(CreateAwsLogSource, request)
            def getDatalakeStatus(request: GetDatalakeStatusRequest): ZStream[
              Any,
              AwsError,
              zio.aws.securitylake.model.AccountSources.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetDatalakeStatus, request)
                }
                .getOrThrowFiberFailure()
            }
            def getDatalakeStatusPaginated(
                request: GetDatalakeStatusRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.GetDatalakeStatusResponse.ReadOnly
            ] = proxy(GetDatalakeStatusPaginated, request)
            def deleteCustomLogSource(
                request: DeleteCustomLogSourceRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.DeleteCustomLogSourceResponse.ReadOnly
            ] = proxy(DeleteCustomLogSource, request)
            def deleteDatalakeDelegatedAdmin(
                request: DeleteDatalakeDelegatedAdminRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.DeleteDatalakeDelegatedAdminResponse.ReadOnly
            ] = proxy(DeleteDatalakeDelegatedAdmin, request)
            def createDatalake(request: CreateDatalakeRequest): IO[
              AwsError,
              zio.aws.securitylake.model.CreateDatalakeResponse.ReadOnly
            ] = proxy(CreateDatalake, request)
            def listSubscribers(request: ListSubscribersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.securitylake.model.SubscriberResource.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSubscribers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSubscribersPaginated(request: ListSubscribersRequest): IO[
              AwsError,
              zio.aws.securitylake.model.ListSubscribersResponse.ReadOnly
            ] = proxy(ListSubscribersPaginated, request)
            def getDatalakeExceptionsExpiry(
                request: GetDatalakeExceptionsExpiryRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.GetDatalakeExceptionsExpiryResponse.ReadOnly
            ] = proxy(GetDatalakeExceptionsExpiry, request)
            def createSubscriber(request: CreateSubscriberRequest): IO[
              AwsError,
              zio.aws.securitylake.model.CreateSubscriberResponse.ReadOnly
            ] = proxy(CreateSubscriber, request)
            def getDatalake(request: GetDatalakeRequest): IO[
              AwsError,
              zio.aws.securitylake.model.GetDatalakeResponse.ReadOnly
            ] = proxy(GetDatalake, request)
            def updateSubscriptionNotificationConfiguration(
                request: UpdateSubscriptionNotificationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse.ReadOnly
            ] = proxy(UpdateSubscriptionNotificationConfiguration, request)
            def getDatalakeAutoEnable(
                request: GetDatalakeAutoEnableRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.GetDatalakeAutoEnableResponse.ReadOnly
            ] = proxy(GetDatalakeAutoEnable, request)
            def updateDatalakeExceptionsExpiry(
                request: UpdateDatalakeExceptionsExpiryRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.UpdateDatalakeExceptionsExpiryResponse.ReadOnly
            ] = proxy(UpdateDatalakeExceptionsExpiry, request)
            def createDatalakeDelegatedAdmin(
                request: CreateDatalakeDelegatedAdminRequest
            ): IO[AwsError, ReadOnly] =
              proxy(CreateDatalakeDelegatedAdmin, request)
            def deleteDatalakeAutoEnable(
                request: DeleteDatalakeAutoEnableRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.DeleteDatalakeAutoEnableResponse.ReadOnly
            ] = proxy(DeleteDatalakeAutoEnable, request)
          }
        }
      }
    }
  }
}
