package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AutoEnableNewRegionConfiguration(
    region: zio.aws.securitylake.model.Region,
    sources: Iterable[zio.aws.securitylake.model.AwsLogSourceType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.AutoEnableNewRegionConfiguration = {
    import AutoEnableNewRegionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.AutoEnableNewRegionConfiguration
      .builder()
      .region(region.unwrap)
      .sourcesWithStrings(sources.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.AutoEnableNewRegionConfiguration.ReadOnly =
    zio.aws.securitylake.model.AutoEnableNewRegionConfiguration
      .wrap(buildAwsValue())
}
object AutoEnableNewRegionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.AutoEnableNewRegionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.AutoEnableNewRegionConfiguration =
      zio.aws.securitylake.model
        .AutoEnableNewRegionConfiguration(region, sources)
    def region: zio.aws.securitylake.model.Region
    def sources: List[zio.aws.securitylake.model.AwsLogSourceType]
    def getRegion: ZIO[Any, Nothing, zio.aws.securitylake.model.Region] =
      ZIO.succeed(region)
    def getSources
        : ZIO[Any, Nothing, List[zio.aws.securitylake.model.AwsLogSourceType]] =
      ZIO.succeed(sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.AutoEnableNewRegionConfiguration
  ) extends zio.aws.securitylake.model.AutoEnableNewRegionConfiguration.ReadOnly {
    override val region: zio.aws.securitylake.model.Region =
      zio.aws.securitylake.model.Region.wrap(impl.region())
    override val sources: List[zio.aws.securitylake.model.AwsLogSourceType] =
      impl
        .sources()
        .asScala
        .map { item =>
          zio.aws.securitylake.model.AwsLogSourceType.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.AutoEnableNewRegionConfiguration
  ): zio.aws.securitylake.model.AutoEnableNewRegionConfiguration.ReadOnly =
    new Wrapper(impl)
}
