package zio.aws.securitylake.model
import scala.jdk.CollectionConverters.*
sealed trait AwsLogSourceType {
  def unwrap
      : software.amazon.awssdk.services.securitylake.model.AwsLogSourceType
}
object AwsLogSourceType {
  def wrap(
      value: software.amazon.awssdk.services.securitylake.model.AwsLogSourceType
  ): zio.aws.securitylake.model.AwsLogSourceType = value match {
    case software.amazon.awssdk.services.securitylake.model.AwsLogSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securitylake.model.AwsLogSourceType.ROUTE53 =>
      val r = ROUTE53
      r
    case software.amazon.awssdk.services.securitylake.model.AwsLogSourceType.VPC_FLOW =>
      val r = VPC_FLOW
      r
    case software.amazon.awssdk.services.securitylake.model.AwsLogSourceType.CLOUD_TRAIL =>
      val r = CLOUD_TRAIL
      r
    case software.amazon.awssdk.services.securitylake.model.AwsLogSourceType.SH_FINDINGS =>
      val r = SH_FINDINGS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securitylake.model.AwsLogSourceType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.AwsLogSourceType =
      software.amazon.awssdk.services.securitylake.model.AwsLogSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ROUTE53 extends zio.aws.securitylake.model.AwsLogSourceType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.AwsLogSourceType =
      software.amazon.awssdk.services.securitylake.model.AwsLogSourceType.ROUTE53
  }
  case object VPC_FLOW extends zio.aws.securitylake.model.AwsLogSourceType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.AwsLogSourceType =
      software.amazon.awssdk.services.securitylake.model.AwsLogSourceType.VPC_FLOW
  }
  case object CLOUD_TRAIL extends zio.aws.securitylake.model.AwsLogSourceType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.AwsLogSourceType =
      software.amazon.awssdk.services.securitylake.model.AwsLogSourceType.CLOUD_TRAIL
  }
  case object SH_FINDINGS extends zio.aws.securitylake.model.AwsLogSourceType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.AwsLogSourceType =
      software.amazon.awssdk.services.securitylake.model.AwsLogSourceType.SH_FINDINGS
  }
}
