package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.SafeString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAwsLogSourceRequest(
    enableAllDimensions: Optional[Map[String, Map[String, Iterable[String]]]] =
      Optional.Absent,
    enableSingleDimension: Optional[Iterable[SafeString]] = Optional.Absent,
    enableTwoDimensions: Optional[Map[String, Iterable[String]]] =
      Optional.Absent,
    inputOrder: Iterable[zio.aws.securitylake.model.Dimension]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceRequest = {
    import CreateAwsLogSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceRequest
      .builder()
      .optionallyWith(
        enableAllDimensions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value
                .map({ case (key, value) =>
                  (key: java.lang.String) -> value.map { item =>
                    item: java.lang.String
                  }.asJavaCollection
                })
                .asJava
            })
            .asJava
        )
      )(_.enableAllDimensions)
      .optionallyWith(
        enableSingleDimension.map(value =>
          value.map { item =>
            SafeString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.enableSingleDimension)
      .optionallyWith(
        enableTwoDimensions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.enableTwoDimensions)
      .inputOrderWithStrings(inputOrder.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.CreateAwsLogSourceRequest.ReadOnly =
    zio.aws.securitylake.model.CreateAwsLogSourceRequest.wrap(buildAwsValue())
}
object CreateAwsLogSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CreateAwsLogSourceRequest =
      zio.aws.securitylake.model.CreateAwsLogSourceRequest(
        enableAllDimensions.map(value => value),
        enableSingleDimension.map(value => value),
        enableTwoDimensions.map(value => value),
        inputOrder
      )
    def enableAllDimensions: Optional[Map[String, Map[String, List[String]]]]
    def enableSingleDimension: Optional[List[SafeString]]
    def enableTwoDimensions: Optional[Map[String, List[String]]]
    def inputOrder: List[zio.aws.securitylake.model.Dimension]
    def getEnableAllDimensions
        : ZIO[Any, AwsError, Map[String, Map[String, List[String]]]] =
      AwsError.unwrapOptionField("enableAllDimensions", enableAllDimensions)
    def getEnableSingleDimension: ZIO[Any, AwsError, List[SafeString]] =
      AwsError.unwrapOptionField("enableSingleDimension", enableSingleDimension)
    def getEnableTwoDimensions: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("enableTwoDimensions", enableTwoDimensions)
    def getInputOrder
        : ZIO[Any, Nothing, List[zio.aws.securitylake.model.Dimension]] =
      ZIO.succeed(inputOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceRequest
  ) extends zio.aws.securitylake.model.CreateAwsLogSourceRequest.ReadOnly {
    override val enableAllDimensions
        : Optional[Map[String, Map[String, List[String]]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableAllDimensions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala
                .map({ case (key, value) =>
                  (key: String) -> value.asScala.map { item =>
                    item: String
                  }.toList
                })
                .toMap
            })
            .toMap
        )
    override val enableSingleDimension: Optional[List[SafeString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableSingleDimension())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.primitives.SafeString(item)
          }.toList
        )
    override val enableTwoDimensions: Optional[Map[String, List[String]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableTwoDimensions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala.map { item =>
                item: String
              }.toList
            })
            .toMap
        )
    override val inputOrder: List[zio.aws.securitylake.model.Dimension] = impl
      .inputOrder()
      .asScala
      .map { item =>
        zio.aws.securitylake.model.Dimension.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceRequest
  ): zio.aws.securitylake.model.CreateAwsLogSourceRequest.ReadOnly =
    new Wrapper(impl)
}
