package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAwsLogSourceResponse(
    failed: Optional[Iterable[String]] = Optional.Absent,
    processing: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceResponse = {
    import CreateAwsLogSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceResponse
      .builder()
      .optionallyWith(
        failed.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.failed)
      .optionallyWith(
        processing.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.processing)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.CreateAwsLogSourceResponse.ReadOnly =
    zio.aws.securitylake.model.CreateAwsLogSourceResponse.wrap(buildAwsValue())
}
object CreateAwsLogSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CreateAwsLogSourceResponse =
      zio.aws.securitylake.model.CreateAwsLogSourceResponse(
        failed.map(value => value),
        processing.map(value => value)
      )
    def failed: Optional[List[String]]
    def processing: Optional[List[String]]
    def getFailed: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("failed", failed)
    def getProcessing: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("processing", processing)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceResponse
  ) extends zio.aws.securitylake.model.CreateAwsLogSourceResponse.ReadOnly {
    override val failed: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.failed())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val processing: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.processing())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceResponse
  ): zio.aws.securitylake.model.CreateAwsLogSourceResponse.ReadOnly =
    new Wrapper(impl)
}
