package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{
  AwsAccountId,
  RoleArn,
  CustomSourceType
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateCustomLogSourceRequest(
    customSourceName: CustomSourceType,
    eventClass: zio.aws.securitylake.model.OcsfEventClass,
    glueInvocationRoleArn: RoleArn,
    logProviderAccountId: AwsAccountId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceRequest = {
    import CreateCustomLogSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceRequest
      .builder()
      .customSourceName(
        CustomSourceType.unwrap(customSourceName): java.lang.String
      )
      .eventClass(eventClass.unwrap)
      .glueInvocationRoleArn(
        RoleArn.unwrap(glueInvocationRoleArn): java.lang.String
      )
      .logProviderAccountId(
        AwsAccountId.unwrap(logProviderAccountId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.CreateCustomLogSourceRequest.ReadOnly =
    zio.aws.securitylake.model.CreateCustomLogSourceRequest
      .wrap(buildAwsValue())
}
object CreateCustomLogSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CreateCustomLogSourceRequest =
      zio.aws.securitylake.model.CreateCustomLogSourceRequest(
        customSourceName,
        eventClass,
        glueInvocationRoleArn,
        logProviderAccountId
      )
    def customSourceName: CustomSourceType
    def eventClass: zio.aws.securitylake.model.OcsfEventClass
    def glueInvocationRoleArn: RoleArn
    def logProviderAccountId: AwsAccountId
    def getCustomSourceName: ZIO[Any, Nothing, CustomSourceType] =
      ZIO.succeed(customSourceName)
    def getEventClass
        : ZIO[Any, Nothing, zio.aws.securitylake.model.OcsfEventClass] =
      ZIO.succeed(eventClass)
    def getGlueInvocationRoleArn: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(glueInvocationRoleArn)
    def getLogProviderAccountId: ZIO[Any, Nothing, AwsAccountId] =
      ZIO.succeed(logProviderAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceRequest
  ) extends zio.aws.securitylake.model.CreateCustomLogSourceRequest.ReadOnly {
    override val customSourceName: CustomSourceType =
      zio.aws.securitylake.model.primitives
        .CustomSourceType(impl.customSourceName())
    override val eventClass: zio.aws.securitylake.model.OcsfEventClass =
      zio.aws.securitylake.model.OcsfEventClass.wrap(impl.eventClass())
    override val glueInvocationRoleArn: RoleArn =
      zio.aws.securitylake.model.primitives
        .RoleArn(impl.glueInvocationRoleArn())
    override val logProviderAccountId: AwsAccountId =
      zio.aws.securitylake.model.primitives
        .AwsAccountId(impl.logProviderAccountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceRequest
  ): zio.aws.securitylake.model.CreateCustomLogSourceRequest.ReadOnly =
    new Wrapper(impl)
}
