package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.SafeString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSubscriptionNotificationConfigurationResponse(
    queueArn: Optional[SafeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateSubscriptionNotificationConfigurationResponse = {
    import CreateSubscriptionNotificationConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateSubscriptionNotificationConfigurationResponse
      .builder()
      .optionallyWith(
        queueArn.map(value => SafeString.unwrap(value): java.lang.String)
      )(_.queueArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.CreateSubscriptionNotificationConfigurationResponse.ReadOnly =
    zio.aws.securitylake.model.CreateSubscriptionNotificationConfigurationResponse
      .wrap(buildAwsValue())
}
object CreateSubscriptionNotificationConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateSubscriptionNotificationConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.CreateSubscriptionNotificationConfigurationResponse =
      zio.aws.securitylake.model
        .CreateSubscriptionNotificationConfigurationResponse(
          queueArn.map(value => value)
        )
    def queueArn: Optional[SafeString]
    def getQueueArn: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("queueArn", queueArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateSubscriptionNotificationConfigurationResponse
  ) extends zio.aws.securitylake.model.CreateSubscriptionNotificationConfigurationResponse.ReadOnly {
    override val queueArn: Optional[SafeString] = zio.aws.core.internal
      .optionalFromNullable(impl.queueArn())
      .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateSubscriptionNotificationConfigurationResponse
  ): zio.aws.securitylake.model.CreateSubscriptionNotificationConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
