package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.SafeString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteAwsLogSourceRequest(
    disableAllDimensions: Optional[Map[String, Map[String, Iterable[String]]]] =
      Optional.Absent,
    disableSingleDimension: Optional[Iterable[SafeString]] = Optional.Absent,
    disableTwoDimensions: Optional[Map[String, Iterable[String]]] =
      Optional.Absent,
    inputOrder: Iterable[zio.aws.securitylake.model.Dimension]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceRequest = {
    import DeleteAwsLogSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceRequest
      .builder()
      .optionallyWith(
        disableAllDimensions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value
                .map({ case (key, value) =>
                  (key: java.lang.String) -> value.map { item =>
                    item: java.lang.String
                  }.asJavaCollection
                })
                .asJava
            })
            .asJava
        )
      )(_.disableAllDimensions)
      .optionallyWith(
        disableSingleDimension.map(value =>
          value.map { item =>
            SafeString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.disableSingleDimension)
      .optionallyWith(
        disableTwoDimensions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.disableTwoDimensions)
      .inputOrderWithStrings(inputOrder.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.DeleteAwsLogSourceRequest.ReadOnly =
    zio.aws.securitylake.model.DeleteAwsLogSourceRequest.wrap(buildAwsValue())
}
object DeleteAwsLogSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DeleteAwsLogSourceRequest =
      zio.aws.securitylake.model.DeleteAwsLogSourceRequest(
        disableAllDimensions.map(value => value),
        disableSingleDimension.map(value => value),
        disableTwoDimensions.map(value => value),
        inputOrder
      )
    def disableAllDimensions: Optional[Map[String, Map[String, List[String]]]]
    def disableSingleDimension: Optional[List[SafeString]]
    def disableTwoDimensions: Optional[Map[String, List[String]]]
    def inputOrder: List[zio.aws.securitylake.model.Dimension]
    def getDisableAllDimensions
        : ZIO[Any, AwsError, Map[String, Map[String, List[String]]]] =
      AwsError.unwrapOptionField("disableAllDimensions", disableAllDimensions)
    def getDisableSingleDimension: ZIO[Any, AwsError, List[SafeString]] =
      AwsError.unwrapOptionField(
        "disableSingleDimension",
        disableSingleDimension
      )
    def getDisableTwoDimensions: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("disableTwoDimensions", disableTwoDimensions)
    def getInputOrder
        : ZIO[Any, Nothing, List[zio.aws.securitylake.model.Dimension]] =
      ZIO.succeed(inputOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceRequest
  ) extends zio.aws.securitylake.model.DeleteAwsLogSourceRequest.ReadOnly {
    override val disableAllDimensions
        : Optional[Map[String, Map[String, List[String]]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableAllDimensions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala
                .map({ case (key, value) =>
                  (key: String) -> value.asScala.map { item =>
                    item: String
                  }.toList
                })
                .toMap
            })
            .toMap
        )
    override val disableSingleDimension: Optional[List[SafeString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableSingleDimension())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.primitives.SafeString(item)
          }.toList
        )
    override val disableTwoDimensions: Optional[Map[String, List[String]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableTwoDimensions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala.map { item =>
                item: String
              }.toList
            })
            .toMap
        )
    override val inputOrder: List[zio.aws.securitylake.model.Dimension] = impl
      .inputOrder()
      .asScala
      .map { item =>
        zio.aws.securitylake.model.Dimension.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceRequest
  ): zio.aws.securitylake.model.DeleteAwsLogSourceRequest.ReadOnly =
    new Wrapper(impl)
}
