package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.SafeString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDatalakeExceptionsSubscriptionResponse(
    status: SafeString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse = {
    import DeleteDatalakeExceptionsSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse
      .builder()
      .status(SafeString.unwrap(status): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse.ReadOnly =
    zio.aws.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse
      .wrap(buildAwsValue())
}
object DeleteDatalakeExceptionsSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse =
      zio.aws.securitylake.model
        .DeleteDatalakeExceptionsSubscriptionResponse(status)
    def status: SafeString
    def getStatus: ZIO[Any, Nothing, SafeString] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse
  ) extends zio.aws.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse.ReadOnly {
    override val status: SafeString =
      zio.aws.securitylake.model.primitives.SafeString(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse
  ): zio.aws.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
