package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.UUID
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSubscriptionNotificationConfigurationRequest(
    subscriptionId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DeleteSubscriptionNotificationConfigurationRequest = {
    import DeleteSubscriptionNotificationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DeleteSubscriptionNotificationConfigurationRequest
      .builder()
      .subscriptionId(UUID.unwrap(subscriptionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.DeleteSubscriptionNotificationConfigurationRequest.ReadOnly =
    zio.aws.securitylake.model.DeleteSubscriptionNotificationConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteSubscriptionNotificationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DeleteSubscriptionNotificationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.DeleteSubscriptionNotificationConfigurationRequest =
      zio.aws.securitylake.model
        .DeleteSubscriptionNotificationConfigurationRequest(subscriptionId)
    def subscriptionId: UUID
    def getSubscriptionId: ZIO[Any, Nothing, UUID] = ZIO.succeed(subscriptionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteSubscriptionNotificationConfigurationRequest
  ) extends zio.aws.securitylake.model.DeleteSubscriptionNotificationConfigurationRequest.ReadOnly {
    override val subscriptionId: UUID =
      zio.aws.securitylake.model.primitives.UUID(impl.subscriptionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteSubscriptionNotificationConfigurationRequest
  ): zio.aws.securitylake.model.DeleteSubscriptionNotificationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
