package zio.aws.securitylake.model
import scala.jdk.CollectionConverters.*
sealed trait Dimension {
  def unwrap: software.amazon.awssdk.services.securitylake.model.Dimension
}
object Dimension {
  def wrap(
      value: software.amazon.awssdk.services.securitylake.model.Dimension
  ): zio.aws.securitylake.model.Dimension = value match {
    case software.amazon.awssdk.services.securitylake.model.Dimension.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securitylake.model.Dimension.REGION =>
      val r = REGION
      r
    case software.amazon.awssdk.services.securitylake.model.Dimension.SOURCE_TYPE =>
      val r = SOURCE_TYPE
      r
    case software.amazon.awssdk.services.securitylake.model.Dimension.MEMBER =>
      val r = MEMBER
      r
  }
  case object unknownToSdkVersion extends zio.aws.securitylake.model.Dimension {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.Dimension =
      software.amazon.awssdk.services.securitylake.model.Dimension.UNKNOWN_TO_SDK_VERSION
  }
  case object REGION extends zio.aws.securitylake.model.Dimension {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.Dimension =
      software.amazon.awssdk.services.securitylake.model.Dimension.REGION
  }
  case object SOURCE_TYPE extends zio.aws.securitylake.model.Dimension {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.Dimension =
      software.amazon.awssdk.services.securitylake.model.Dimension.SOURCE_TYPE
  }
  case object MEMBER extends zio.aws.securitylake.model.Dimension {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.Dimension =
      software.amazon.awssdk.services.securitylake.model.Dimension.MEMBER
  }
}
