package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{Integer, SafeString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDatalakeStatusRequest(
    accountSet: Optional[Iterable[SafeString]] = Optional.Absent,
    maxAccountResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[SafeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest = {
    import GetDatalakeStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest
      .builder()
      .optionallyWith(
        accountSet.map(value =>
          value.map { item =>
            SafeString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountSet)
      .optionallyWith(maxAccountResults.map(value => value: java.lang.Integer))(
        _.maxAccountResults
      )
      .optionallyWith(
        nextToken.map(value => SafeString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.GetDatalakeStatusRequest.ReadOnly =
    zio.aws.securitylake.model.GetDatalakeStatusRequest.wrap(buildAwsValue())
}
object GetDatalakeStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.GetDatalakeStatusRequest =
      zio.aws.securitylake.model.GetDatalakeStatusRequest(
        accountSet.map(value => value),
        maxAccountResults.map(value => value),
        nextToken.map(value => value)
      )
    def accountSet: Optional[List[SafeString]]
    def maxAccountResults: Optional[Integer]
    def nextToken: Optional[SafeString]
    def getAccountSet: ZIO[Any, AwsError, List[SafeString]] =
      AwsError.unwrapOptionField("accountSet", accountSet)
    def getMaxAccountResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxAccountResults", maxAccountResults)
    def getNextToken: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest
  ) extends zio.aws.securitylake.model.GetDatalakeStatusRequest.ReadOnly {
    override val accountSet: Optional[List[SafeString]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securitylake.model.primitives.SafeString(item)
        }.toList
      )
    override val maxAccountResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxAccountResults())
      .map(value => value: Integer)
    override val nextToken: Optional[SafeString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest
  ): zio.aws.securitylake.model.GetDatalakeStatusRequest.ReadOnly = new Wrapper(
    impl
  )
}
