package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.SafeString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDatalakeStatusResponse(
    accountSourcesList: Iterable[zio.aws.securitylake.model.AccountSources],
    nextToken: Optional[SafeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusResponse = {
    import GetDatalakeStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusResponse
      .builder()
      .accountSourcesList(accountSourcesList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => SafeString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.GetDatalakeStatusResponse.ReadOnly =
    zio.aws.securitylake.model.GetDatalakeStatusResponse.wrap(buildAwsValue())
}
object GetDatalakeStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.GetDatalakeStatusResponse =
      zio.aws.securitylake.model.GetDatalakeStatusResponse(
        accountSourcesList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def accountSourcesList
        : List[zio.aws.securitylake.model.AccountSources.ReadOnly]
    def nextToken: Optional[SafeString]
    def getAccountSourcesList: ZIO[Any, Nothing, List[
      zio.aws.securitylake.model.AccountSources.ReadOnly
    ]] = ZIO.succeed(accountSourcesList)
    def getNextToken: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusResponse
  ) extends zio.aws.securitylake.model.GetDatalakeStatusResponse.ReadOnly {
    override val accountSourcesList
        : List[zio.aws.securitylake.model.AccountSources.ReadOnly] = impl
      .accountSourcesList()
      .asScala
      .map { item =>
        zio.aws.securitylake.model.AccountSources.wrap(item)
      }
      .toList
    override val nextToken: Optional[SafeString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusResponse
  ): zio.aws.securitylake.model.GetDatalakeStatusResponse.ReadOnly =
    new Wrapper(impl)
}
