package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSubscriberResponse(
    subscriber: Optional[zio.aws.securitylake.model.SubscriberResource] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.GetSubscriberResponse = {
    import GetSubscriberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.GetSubscriberResponse
      .builder()
      .optionallyWith(subscriber.map(value => value.buildAwsValue()))(
        _.subscriber
      )
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.GetSubscriberResponse.ReadOnly =
    zio.aws.securitylake.model.GetSubscriberResponse.wrap(buildAwsValue())
}
object GetSubscriberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.GetSubscriberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.GetSubscriberResponse =
      zio.aws.securitylake.model
        .GetSubscriberResponse(subscriber.map(value => value.asEditable))
    def subscriber
        : Optional[zio.aws.securitylake.model.SubscriberResource.ReadOnly]
    def getSubscriber: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.SubscriberResource.ReadOnly
    ] = AwsError.unwrapOptionField("subscriber", subscriber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.GetSubscriberResponse
  ) extends zio.aws.securitylake.model.GetSubscriberResponse.ReadOnly {
    override val subscriber
        : Optional[zio.aws.securitylake.model.SubscriberResource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriber())
        .map(value => zio.aws.securitylake.model.SubscriberResource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.GetSubscriberResponse
  ): zio.aws.securitylake.model.GetSubscriberResponse.ReadOnly = new Wrapper(
    impl
  )
}
