package zio.aws.securitylake.model
import scala.jdk.CollectionConverters.*
sealed trait HttpsMethod {
  def unwrap: software.amazon.awssdk.services.securitylake.model.HttpsMethod
}
object HttpsMethod {
  def wrap(
      value: software.amazon.awssdk.services.securitylake.model.HttpsMethod
  ): zio.aws.securitylake.model.HttpsMethod = value match {
    case software.amazon.awssdk.services.securitylake.model.HttpsMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securitylake.model.HttpsMethod.POST =>
      val r = POST
      r
    case software.amazon.awssdk.services.securitylake.model.HttpsMethod.PUT =>
      val r = PUT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securitylake.model.HttpsMethod {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.HttpsMethod =
      software.amazon.awssdk.services.securitylake.model.HttpsMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object POST extends zio.aws.securitylake.model.HttpsMethod {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.HttpsMethod =
      software.amazon.awssdk.services.securitylake.model.HttpsMethod.POST
  }
  case object PUT extends zio.aws.securitylake.model.HttpsMethod {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.HttpsMethod =
      software.amazon.awssdk.services.securitylake.model.HttpsMethod.PUT
  }
}
