package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.RoleArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LakeConfigurationRequest(
    encryptionKey: Optional[String] = Optional.Absent,
    replicationDestinationRegions: Optional[
      Iterable[zio.aws.securitylake.model.Region]
    ] = Optional.Absent,
    replicationRoleArn: Optional[RoleArn] = Optional.Absent,
    retentionSettings: Optional[
      Iterable[zio.aws.securitylake.model.RetentionSetting]
    ] = Optional.Absent,
    tagsMap: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.LakeConfigurationRequest = {
    import LakeConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.LakeConfigurationRequest
      .builder()
      .optionallyWith(encryptionKey.map(value => value: java.lang.String))(
        _.encryptionKey
      )
      .optionallyWith(
        replicationDestinationRegions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.replicationDestinationRegionsWithStrings)
      .optionallyWith(
        replicationRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.replicationRoleArn)
      .optionallyWith(
        retentionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.retentionSettings)
      .optionallyWith(
        tagsMap.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tagsMap)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.LakeConfigurationRequest.ReadOnly =
    zio.aws.securitylake.model.LakeConfigurationRequest.wrap(buildAwsValue())
}
object LakeConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.LakeConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.LakeConfigurationRequest =
      zio.aws.securitylake.model.LakeConfigurationRequest(
        encryptionKey.map(value => value),
        replicationDestinationRegions.map(value => value),
        replicationRoleArn.map(value => value),
        retentionSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagsMap.map(value => value)
      )
    def encryptionKey: Optional[String]
    def replicationDestinationRegions
        : Optional[List[zio.aws.securitylake.model.Region]]
    def replicationRoleArn: Optional[RoleArn]
    def retentionSettings
        : Optional[List[zio.aws.securitylake.model.RetentionSetting.ReadOnly]]
    def tagsMap: Optional[Map[String, String]]
    def getEncryptionKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getReplicationDestinationRegions
        : ZIO[Any, AwsError, List[zio.aws.securitylake.model.Region]] =
      AwsError.unwrapOptionField(
        "replicationDestinationRegions",
        replicationDestinationRegions
      )
    def getReplicationRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("replicationRoleArn", replicationRoleArn)
    def getRetentionSettings: ZIO[Any, AwsError, List[
      zio.aws.securitylake.model.RetentionSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("retentionSettings", retentionSettings)
    def getTagsMap: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tagsMap", tagsMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.LakeConfigurationRequest
  ) extends zio.aws.securitylake.model.LakeConfigurationRequest.ReadOnly {
    override val encryptionKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKey())
      .map(value => value: String)
    override val replicationDestinationRegions
        : Optional[List[zio.aws.securitylake.model.Region]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationDestinationRegions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.Region.wrap(item)
          }.toList
        )
    override val replicationRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationRoleArn())
      .map(value => zio.aws.securitylake.model.primitives.RoleArn(value))
    override val retentionSettings
        : Optional[List[zio.aws.securitylake.model.RetentionSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.RetentionSetting.wrap(item)
          }.toList
        )
    override val tagsMap: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagsMap())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.LakeConfigurationRequest
  ): zio.aws.securitylake.model.LakeConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
