package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{SafeString, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDatalakeExceptionsRequest(
    maxFailures: Optional[Integer] = Optional.Absent,
    nextToken: Optional[SafeString] = Optional.Absent,
    regionSet: Optional[Iterable[zio.aws.securitylake.model.Region]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest = {
    import ListDatalakeExceptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest
      .builder()
      .optionallyWith(maxFailures.map(value => value: java.lang.Integer))(
        _.maxFailures
      )
      .optionallyWith(
        nextToken.map(value => SafeString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        regionSet.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.regionSetWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.ListDatalakeExceptionsRequest.ReadOnly =
    zio.aws.securitylake.model.ListDatalakeExceptionsRequest
      .wrap(buildAwsValue())
}
object ListDatalakeExceptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.ListDatalakeExceptionsRequest =
      zio.aws.securitylake.model.ListDatalakeExceptionsRequest(
        maxFailures.map(value => value),
        nextToken.map(value => value),
        regionSet.map(value => value)
      )
    def maxFailures: Optional[Integer]
    def nextToken: Optional[SafeString]
    def regionSet: Optional[List[zio.aws.securitylake.model.Region]]
    def getMaxFailures: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxFailures", maxFailures)
    def getNextToken: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRegionSet
        : ZIO[Any, AwsError, List[zio.aws.securitylake.model.Region]] =
      AwsError.unwrapOptionField("regionSet", regionSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest
  ) extends zio.aws.securitylake.model.ListDatalakeExceptionsRequest.ReadOnly {
    override val maxFailures: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxFailures())
      .map(value => value: Integer)
    override val nextToken: Optional[SafeString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
    override val regionSet: Optional[List[zio.aws.securitylake.model.Region]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regionSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.Region.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest
  ): zio.aws.securitylake.model.ListDatalakeExceptionsRequest.ReadOnly =
    new Wrapper(impl)
}
