package zio.aws.securitylake.model
import scala.jdk.CollectionConverters.*
sealed trait Region {
  def unwrap: software.amazon.awssdk.services.securitylake.model.Region
}
object Region {
  def wrap(
      value: software.amazon.awssdk.services.securitylake.model.Region
  ): zio.aws.securitylake.model.Region = value match {
    case software.amazon.awssdk.services.securitylake.model.Region.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securitylake.model.Region.US_EAST_1 =>
      val r = `us-east-1`
      r
    case software.amazon.awssdk.services.securitylake.model.Region.US_WEST_2 =>
      val r = `us-west-2`
      r
    case software.amazon.awssdk.services.securitylake.model.Region.EU_CENTRAL_1 =>
      val r = `eu-central-1`
      r
    case software.amazon.awssdk.services.securitylake.model.Region.US_EAST_2 =>
      val r = `us-east-2`
      r
    case software.amazon.awssdk.services.securitylake.model.Region.EU_WEST_1 =>
      val r = `eu-west-1`
      r
    case software.amazon.awssdk.services.securitylake.model.Region.AP_NORTHEAST_1 =>
      val r = `ap-northeast-1`
      r
    case software.amazon.awssdk.services.securitylake.model.Region.AP_SOUTHEAST_2 =>
      val r = `ap-southeast-2`
      r
  }
  case object unknownToSdkVersion extends zio.aws.securitylake.model.Region {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.Region =
      software.amazon.awssdk.services.securitylake.model.Region.UNKNOWN_TO_SDK_VERSION
  }
  case object `us-east-1` extends zio.aws.securitylake.model.Region {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.Region =
      software.amazon.awssdk.services.securitylake.model.Region.US_EAST_1
  }
  case object `us-west-2` extends zio.aws.securitylake.model.Region {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.Region =
      software.amazon.awssdk.services.securitylake.model.Region.US_WEST_2
  }
  case object `eu-central-1` extends zio.aws.securitylake.model.Region {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.Region =
      software.amazon.awssdk.services.securitylake.model.Region.EU_CENTRAL_1
  }
  case object `us-east-2` extends zio.aws.securitylake.model.Region {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.Region =
      software.amazon.awssdk.services.securitylake.model.Region.US_EAST_2
  }
  case object `eu-west-1` extends zio.aws.securitylake.model.Region {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.Region =
      software.amazon.awssdk.services.securitylake.model.Region.EU_WEST_1
  }
  case object `ap-northeast-1` extends zio.aws.securitylake.model.Region {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.Region =
      software.amazon.awssdk.services.securitylake.model.Region.AP_NORTHEAST_1
  }
  case object `ap-southeast-2` extends zio.aws.securitylake.model.Region {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.Region =
      software.amazon.awssdk.services.securitylake.model.Region.AP_SOUTHEAST_2
  }
}
