package zio.aws.securitylake.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.securitylake.model.primitives.{
  RoleArn,
  SafeString,
  S3BucketArn,
  SyntheticTimestamp_date_time,
  SnsTopicArn,
  UUID,
  AwsAccountId
}
import scala.jdk.CollectionConverters.*
final case class SubscriberResource(
    accessTypes: Optional[Iterable[zio.aws.securitylake.model.AccessType]] =
      Optional.Absent,
    accountId: AwsAccountId,
    createdAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    externalId: Optional[SafeString] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    s3BucketArn: Optional[S3BucketArn] = Optional.Absent,
    snsArn: Optional[SnsTopicArn] = Optional.Absent,
    sourceTypes: Iterable[zio.aws.securitylake.model.SourceType],
    subscriberDescription: Optional[SafeString] = Optional.Absent,
    subscriberName: Optional[SafeString] = Optional.Absent,
    subscriptionEndpoint: Optional[String] = Optional.Absent,
    subscriptionId: UUID,
    subscriptionProtocol: Optional[
      zio.aws.securitylake.model.EndpointProtocol
    ] = Optional.Absent,
    subscriptionStatus: Optional[
      zio.aws.securitylake.model.SubscriptionStatus
    ] = Optional.Absent,
    updatedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.SubscriberResource = {
    import SubscriberResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.SubscriberResource
      .builder()
      .optionallyWith(
        accessTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.accessTypesWithStrings)
      .accountId(AwsAccountId.unwrap(accountId): java.lang.String)
      .optionallyWith(
        createdAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAt)
      .optionallyWith(
        externalId.map(value => SafeString.unwrap(value): java.lang.String)
      )(_.externalId)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        s3BucketArn.map(value => S3BucketArn.unwrap(value): java.lang.String)
      )(_.s3BucketArn)
      .optionallyWith(
        snsArn.map(value => SnsTopicArn.unwrap(value): java.lang.String)
      )(_.snsArn)
      .sourceTypes(sourceTypes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        subscriberDescription.map(value =>
          SafeString.unwrap(value): java.lang.String
        )
      )(_.subscriberDescription)
      .optionallyWith(
        subscriberName.map(value => SafeString.unwrap(value): java.lang.String)
      )(_.subscriberName)
      .optionallyWith(
        subscriptionEndpoint.map(value => value: java.lang.String)
      )(_.subscriptionEndpoint)
      .subscriptionId(UUID.unwrap(subscriptionId): java.lang.String)
      .optionallyWith(subscriptionProtocol.map(value => value.unwrap))(
        _.subscriptionProtocol
      )
      .optionallyWith(subscriptionStatus.map(value => value.unwrap))(
        _.subscriptionStatus
      )
      .optionallyWith(
        updatedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.updatedAt)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.SubscriberResource.ReadOnly =
    zio.aws.securitylake.model.SubscriberResource.wrap(buildAwsValue())
}
object SubscriberResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.SubscriberResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.SubscriberResource =
      zio.aws.securitylake.model.SubscriberResource(
        accessTypes.map(value => value),
        accountId,
        createdAt.map(value => value),
        externalId.map(value => value),
        roleArn.map(value => value),
        s3BucketArn.map(value => value),
        snsArn.map(value => value),
        sourceTypes.map { item =>
          item.asEditable
        },
        subscriberDescription.map(value => value),
        subscriberName.map(value => value),
        subscriptionEndpoint.map(value => value),
        subscriptionId,
        subscriptionProtocol.map(value => value),
        subscriptionStatus.map(value => value),
        updatedAt.map(value => value)
      )
    def accessTypes: Optional[List[zio.aws.securitylake.model.AccessType]]
    def accountId: AwsAccountId
    def createdAt: Optional[SyntheticTimestamp_date_time]
    def externalId: Optional[SafeString]
    def roleArn: Optional[RoleArn]
    def s3BucketArn: Optional[S3BucketArn]
    def snsArn: Optional[SnsTopicArn]
    def sourceTypes: List[zio.aws.securitylake.model.SourceType.ReadOnly]
    def subscriberDescription: Optional[SafeString]
    def subscriberName: Optional[SafeString]
    def subscriptionEndpoint: Optional[String]
    def subscriptionId: UUID
    def subscriptionProtocol
        : Optional[zio.aws.securitylake.model.EndpointProtocol]
    def subscriptionStatus
        : Optional[zio.aws.securitylake.model.SubscriptionStatus]
    def updatedAt: Optional[SyntheticTimestamp_date_time]
    def getAccessTypes
        : ZIO[Any, AwsError, List[zio.aws.securitylake.model.AccessType]] =
      AwsError.unwrapOptionField("accessTypes", accessTypes)
    def getAccountId: ZIO[Any, Nothing, AwsAccountId] = ZIO.succeed(accountId)
    def getCreatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getExternalId: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getS3BucketArn: ZIO[Any, AwsError, S3BucketArn] =
      AwsError.unwrapOptionField("s3BucketArn", s3BucketArn)
    def getSnsArn: ZIO[Any, AwsError, SnsTopicArn] =
      AwsError.unwrapOptionField("snsArn", snsArn)
    def getSourceTypes: ZIO[Any, Nothing, List[
      zio.aws.securitylake.model.SourceType.ReadOnly
    ]] = ZIO.succeed(sourceTypes)
    def getSubscriberDescription: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("subscriberDescription", subscriberDescription)
    def getSubscriberName: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("subscriberName", subscriberName)
    def getSubscriptionEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subscriptionEndpoint", subscriptionEndpoint)
    def getSubscriptionId: ZIO[Any, Nothing, UUID] = ZIO.succeed(subscriptionId)
    def getSubscriptionProtocol
        : ZIO[Any, AwsError, zio.aws.securitylake.model.EndpointProtocol] =
      AwsError.unwrapOptionField("subscriptionProtocol", subscriptionProtocol)
    def getSubscriptionStatus
        : ZIO[Any, AwsError, zio.aws.securitylake.model.SubscriptionStatus] =
      AwsError.unwrapOptionField("subscriptionStatus", subscriptionStatus)
    def getUpdatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.SubscriberResource
  ) extends zio.aws.securitylake.model.SubscriberResource.ReadOnly {
    override val accessTypes
        : Optional[List[zio.aws.securitylake.model.AccessType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.AccessType.wrap(item)
          }.toList
        )
    override val accountId: AwsAccountId =
      zio.aws.securitylake.model.primitives.AwsAccountId(impl.accountId())
    override val createdAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAt())
        .map(value =>
          zio.aws.securitylake.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val externalId: Optional[SafeString] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.securitylake.model.primitives.RoleArn(value))
    override val s3BucketArn: Optional[S3BucketArn] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketArn())
      .map(value => zio.aws.securitylake.model.primitives.S3BucketArn(value))
    override val snsArn: Optional[SnsTopicArn] = zio.aws.core.internal
      .optionalFromNullable(impl.snsArn())
      .map(value => zio.aws.securitylake.model.primitives.SnsTopicArn(value))
    override val sourceTypes
        : List[zio.aws.securitylake.model.SourceType.ReadOnly] = impl
      .sourceTypes()
      .asScala
      .map { item =>
        zio.aws.securitylake.model.SourceType.wrap(item)
      }
      .toList
    override val subscriberDescription: Optional[SafeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriberDescription())
        .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
    override val subscriberName: Optional[SafeString] = zio.aws.core.internal
      .optionalFromNullable(impl.subscriberName())
      .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
    override val subscriptionEndpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subscriptionEndpoint())
      .map(value => value: String)
    override val subscriptionId: UUID =
      zio.aws.securitylake.model.primitives.UUID(impl.subscriptionId())
    override val subscriptionProtocol
        : Optional[zio.aws.securitylake.model.EndpointProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionProtocol())
        .map(value => zio.aws.securitylake.model.EndpointProtocol.wrap(value))
    override val subscriptionStatus
        : Optional[zio.aws.securitylake.model.SubscriptionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionStatus())
        .map(value => zio.aws.securitylake.model.SubscriptionStatus.wrap(value))
    override val updatedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedAt())
        .map(value =>
          zio.aws.securitylake.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.SubscriberResource
  ): zio.aws.securitylake.model.SubscriberResource.ReadOnly = new Wrapper(impl)
}
