package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.SafeString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateDatalakeExceptionsSubscriptionRequest(
    notificationEndpoint: SafeString,
    subscriptionProtocol: zio.aws.securitylake.model.SubscriptionProtocolType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.UpdateDatalakeExceptionsSubscriptionRequest = {
    import UpdateDatalakeExceptionsSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.UpdateDatalakeExceptionsSubscriptionRequest
      .builder()
      .notificationEndpoint(
        SafeString.unwrap(notificationEndpoint): java.lang.String
      )
      .subscriptionProtocol(subscriptionProtocol.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.UpdateDatalakeExceptionsSubscriptionRequest.ReadOnly =
    zio.aws.securitylake.model.UpdateDatalakeExceptionsSubscriptionRequest
      .wrap(buildAwsValue())
}
object UpdateDatalakeExceptionsSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.UpdateDatalakeExceptionsSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.UpdateDatalakeExceptionsSubscriptionRequest =
      zio.aws.securitylake.model.UpdateDatalakeExceptionsSubscriptionRequest(
        notificationEndpoint,
        subscriptionProtocol
      )
    def notificationEndpoint: SafeString
    def subscriptionProtocol
        : zio.aws.securitylake.model.SubscriptionProtocolType
    def getNotificationEndpoint: ZIO[Any, Nothing, SafeString] =
      ZIO.succeed(notificationEndpoint)
    def getSubscriptionProtocol: ZIO[
      Any,
      Nothing,
      zio.aws.securitylake.model.SubscriptionProtocolType
    ] = ZIO.succeed(subscriptionProtocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateDatalakeExceptionsSubscriptionRequest
  ) extends zio.aws.securitylake.model.UpdateDatalakeExceptionsSubscriptionRequest.ReadOnly {
    override val notificationEndpoint: SafeString =
      zio.aws.securitylake.model.primitives
        .SafeString(impl.notificationEndpoint())
    override val subscriptionProtocol
        : zio.aws.securitylake.model.SubscriptionProtocolType =
      zio.aws.securitylake.model.SubscriptionProtocolType
        .wrap(impl.subscriptionProtocol())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateDatalakeExceptionsSubscriptionRequest
  ): zio.aws.securitylake.model.UpdateDatalakeExceptionsSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
