package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{
  UpdateSubscriberRequestSubscriberNameString,
  DescriptionString,
  SafeString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSubscriberRequest(
    externalId: Optional[SafeString] = Optional.Absent,
    id: String,
    sourceTypes: Iterable[zio.aws.securitylake.model.SourceType],
    subscriberDescription: Optional[DescriptionString] = Optional.Absent,
    subscriberName: Optional[UpdateSubscriberRequestSubscriberNameString] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.UpdateSubscriberRequest = {
    import UpdateSubscriberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.UpdateSubscriberRequest
      .builder()
      .optionallyWith(
        externalId.map(value => SafeString.unwrap(value): java.lang.String)
      )(_.externalId)
      .id(id: java.lang.String)
      .sourceTypes(sourceTypes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        subscriberDescription.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.subscriberDescription)
      .optionallyWith(
        subscriberName.map(value =>
          UpdateSubscriberRequestSubscriberNameString.unwrap(
            value
          ): java.lang.String
        )
      )(_.subscriberName)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.UpdateSubscriberRequest.ReadOnly =
    zio.aws.securitylake.model.UpdateSubscriberRequest.wrap(buildAwsValue())
}
object UpdateSubscriberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.UpdateSubscriberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.UpdateSubscriberRequest =
      zio.aws.securitylake.model.UpdateSubscriberRequest(
        externalId.map(value => value),
        id,
        sourceTypes.map { item =>
          item.asEditable
        },
        subscriberDescription.map(value => value),
        subscriberName.map(value => value)
      )
    def externalId: Optional[SafeString]
    def id: String
    def sourceTypes: List[zio.aws.securitylake.model.SourceType.ReadOnly]
    def subscriberDescription: Optional[DescriptionString]
    def subscriberName: Optional[UpdateSubscriberRequestSubscriberNameString]
    def getExternalId: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getSourceTypes: ZIO[Any, Nothing, List[
      zio.aws.securitylake.model.SourceType.ReadOnly
    ]] = ZIO.succeed(sourceTypes)
    def getSubscriberDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("subscriberDescription", subscriberDescription)
    def getSubscriberName
        : ZIO[Any, AwsError, UpdateSubscriberRequestSubscriberNameString] =
      AwsError.unwrapOptionField("subscriberName", subscriberName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateSubscriberRequest
  ) extends zio.aws.securitylake.model.UpdateSubscriberRequest.ReadOnly {
    override val externalId: Optional[SafeString] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
    override val id: String = impl.id(): String
    override val sourceTypes
        : List[zio.aws.securitylake.model.SourceType.ReadOnly] = impl
      .sourceTypes()
      .asScala
      .map { item =>
        zio.aws.securitylake.model.SourceType.wrap(item)
      }
      .toList
    override val subscriberDescription: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriberDescription())
        .map(value =>
          zio.aws.securitylake.model.primitives.DescriptionString(value)
        )
    override val subscriberName
        : Optional[UpdateSubscriberRequestSubscriberNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriberName())
        .map(value =>
          zio.aws.securitylake.model.primitives
            .UpdateSubscriberRequestSubscriberNameString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateSubscriberRequest
  ): zio.aws.securitylake.model.UpdateSubscriberRequest.ReadOnly = new Wrapper(
    impl
  )
}
