package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.SafeString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSubscriptionNotificationConfigurationResponse(
    queueArn: Optional[SafeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse = {
    import UpdateSubscriptionNotificationConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse
      .builder()
      .optionallyWith(
        queueArn.map(value => SafeString.unwrap(value): java.lang.String)
      )(_.queueArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse.ReadOnly =
    zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse
      .wrap(buildAwsValue())
}
object UpdateSubscriptionNotificationConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse =
      zio.aws.securitylake.model
        .UpdateSubscriptionNotificationConfigurationResponse(
          queueArn.map(value => value)
        )
    def queueArn: Optional[SafeString]
    def getQueueArn: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("queueArn", queueArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse
  ) extends zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse.ReadOnly {
    override val queueArn: Optional[SafeString] = zio.aws.core.internal
      .optionalFromNullable(impl.queueArn())
      .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse
  ): zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
