package zio.aws.securitylake.model
import scala.jdk.CollectionConverters.*
sealed trait AccessType {
  def unwrap: software.amazon.awssdk.services.securitylake.model.AccessType
}
object AccessType {
  def wrap(
      value: software.amazon.awssdk.services.securitylake.model.AccessType
  ): zio.aws.securitylake.model.AccessType = value match {
    case software.amazon.awssdk.services.securitylake.model.AccessType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securitylake.model.AccessType.LAKEFORMATION =>
      val r = LAKEFORMATION
      r
    case software.amazon.awssdk.services.securitylake.model.AccessType.S3 =>
      val r = S3
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securitylake.model.AccessType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.AccessType =
      software.amazon.awssdk.services.securitylake.model.AccessType.UNKNOWN_TO_SDK_VERSION
  }
  case object LAKEFORMATION extends zio.aws.securitylake.model.AccessType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.AccessType =
      software.amazon.awssdk.services.securitylake.model.AccessType.LAKEFORMATION
  }
  case object S3 extends zio.aws.securitylake.model.AccessType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.AccessType =
      software.amazon.awssdk.services.securitylake.model.AccessType.S3
  }
}
