package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AccountSources(
    account: String,
    eventClass: Optional[zio.aws.securitylake.model.OcsfEventClass] =
      Optional.Absent,
    logsStatus: Optional[Iterable[zio.aws.securitylake.model.LogsStatus]] =
      Optional.Absent,
    sourceType: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.AccountSources = {
    import AccountSources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.AccountSources
      .builder()
      .account(account: java.lang.String)
      .optionallyWith(eventClass.map(value => value.unwrap))(_.eventClass)
      .optionallyWith(
        logsStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logsStatus)
      .sourceType(sourceType: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.AccountSources.ReadOnly =
    zio.aws.securitylake.model.AccountSources.wrap(buildAwsValue())
}
object AccountSources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.AccountSources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.AccountSources =
      zio.aws.securitylake.model.AccountSources(
        account,
        eventClass.map(value => value),
        logsStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceType
      )
    def account: String
    def eventClass: Optional[zio.aws.securitylake.model.OcsfEventClass]
    def logsStatus
        : Optional[List[zio.aws.securitylake.model.LogsStatus.ReadOnly]]
    def sourceType: String
    def getAccount: ZIO[Any, Nothing, String] = ZIO.succeed(account)
    def getEventClass
        : ZIO[Any, AwsError, zio.aws.securitylake.model.OcsfEventClass] =
      AwsError.unwrapOptionField("eventClass", eventClass)
    def getLogsStatus: ZIO[Any, AwsError, List[
      zio.aws.securitylake.model.LogsStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("logsStatus", logsStatus)
    def getSourceType: ZIO[Any, Nothing, String] = ZIO.succeed(sourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.AccountSources
  ) extends zio.aws.securitylake.model.AccountSources.ReadOnly {
    override val account: String = impl.account(): String
    override val eventClass
        : Optional[zio.aws.securitylake.model.OcsfEventClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventClass())
        .map(value => zio.aws.securitylake.model.OcsfEventClass.wrap(value))
    override val logsStatus
        : Optional[List[zio.aws.securitylake.model.LogsStatus.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logsStatus())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.LogsStatus.wrap(item)
          }.toList
        )
    override val sourceType: String = impl.sourceType(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.AccountSources
  ): zio.aws.securitylake.model.AccountSources.ReadOnly = new Wrapper(impl)
}
