package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateCustomLogSourceResponse(
    customDataLocation: String,
    glueCrawlerName: String,
    glueDatabaseName: String,
    glueTableName: String,
    logProviderAccessRoleArn: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceResponse = {
    import CreateCustomLogSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceResponse
      .builder()
      .customDataLocation(customDataLocation: java.lang.String)
      .glueCrawlerName(glueCrawlerName: java.lang.String)
      .glueDatabaseName(glueDatabaseName: java.lang.String)
      .glueTableName(glueTableName: java.lang.String)
      .logProviderAccessRoleArn(logProviderAccessRoleArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.CreateCustomLogSourceResponse.ReadOnly =
    zio.aws.securitylake.model.CreateCustomLogSourceResponse
      .wrap(buildAwsValue())
}
object CreateCustomLogSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CreateCustomLogSourceResponse =
      zio.aws.securitylake.model.CreateCustomLogSourceResponse(
        customDataLocation,
        glueCrawlerName,
        glueDatabaseName,
        glueTableName,
        logProviderAccessRoleArn
      )
    def customDataLocation: String
    def glueCrawlerName: String
    def glueDatabaseName: String
    def glueTableName: String
    def logProviderAccessRoleArn: String
    def getCustomDataLocation: ZIO[Any, Nothing, String] =
      ZIO.succeed(customDataLocation)
    def getGlueCrawlerName: ZIO[Any, Nothing, String] =
      ZIO.succeed(glueCrawlerName)
    def getGlueDatabaseName: ZIO[Any, Nothing, String] =
      ZIO.succeed(glueDatabaseName)
    def getGlueTableName: ZIO[Any, Nothing, String] = ZIO.succeed(glueTableName)
    def getLogProviderAccessRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(logProviderAccessRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceResponse
  ) extends zio.aws.securitylake.model.CreateCustomLogSourceResponse.ReadOnly {
    override val customDataLocation: String = impl.customDataLocation(): String
    override val glueCrawlerName: String = impl.glueCrawlerName(): String
    override val glueDatabaseName: String = impl.glueDatabaseName(): String
    override val glueTableName: String = impl.glueTableName(): String
    override val logProviderAccessRoleArn: String =
      impl.logProviderAccessRoleArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceResponse
  ): zio.aws.securitylake.model.CreateCustomLogSourceResponse.ReadOnly =
    new Wrapper(impl)
}
