package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.SafeString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateDatalakeDelegatedAdminRequest(account: SafeString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateDatalakeDelegatedAdminRequest = {
    import CreateDatalakeDelegatedAdminRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateDatalakeDelegatedAdminRequest
      .builder()
      .account(SafeString.unwrap(account): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.CreateDatalakeDelegatedAdminRequest.ReadOnly =
    zio.aws.securitylake.model.CreateDatalakeDelegatedAdminRequest
      .wrap(buildAwsValue())
}
object CreateDatalakeDelegatedAdminRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateDatalakeDelegatedAdminRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.CreateDatalakeDelegatedAdminRequest =
      zio.aws.securitylake.model.CreateDatalakeDelegatedAdminRequest(account)
    def account: SafeString
    def getAccount: ZIO[Any, Nothing, SafeString] = ZIO.succeed(account)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateDatalakeDelegatedAdminRequest
  ) extends zio.aws.securitylake.model.CreateDatalakeDelegatedAdminRequest.ReadOnly {
    override val account: SafeString =
      zio.aws.securitylake.model.primitives.SafeString(impl.account())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateDatalakeDelegatedAdminRequest
  ): zio.aws.securitylake.model.CreateDatalakeDelegatedAdminRequest.ReadOnly =
    new Wrapper(impl)
}
