package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.SafeString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateDatalakeExceptionsSubscriptionRequest(
    notificationEndpoint: SafeString,
    subscriptionProtocol: zio.aws.securitylake.model.SubscriptionProtocolType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateDatalakeExceptionsSubscriptionRequest = {
    import CreateDatalakeExceptionsSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateDatalakeExceptionsSubscriptionRequest
      .builder()
      .notificationEndpoint(
        SafeString.unwrap(notificationEndpoint): java.lang.String
      )
      .subscriptionProtocol(subscriptionProtocol.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.CreateDatalakeExceptionsSubscriptionRequest.ReadOnly =
    zio.aws.securitylake.model.CreateDatalakeExceptionsSubscriptionRequest
      .wrap(buildAwsValue())
}
object CreateDatalakeExceptionsSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateDatalakeExceptionsSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.CreateDatalakeExceptionsSubscriptionRequest =
      zio.aws.securitylake.model.CreateDatalakeExceptionsSubscriptionRequest(
        notificationEndpoint,
        subscriptionProtocol
      )
    def notificationEndpoint: SafeString
    def subscriptionProtocol
        : zio.aws.securitylake.model.SubscriptionProtocolType
    def getNotificationEndpoint: ZIO[Any, Nothing, SafeString] =
      ZIO.succeed(notificationEndpoint)
    def getSubscriptionProtocol: ZIO[
      Any,
      Nothing,
      zio.aws.securitylake.model.SubscriptionProtocolType
    ] = ZIO.succeed(subscriptionProtocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateDatalakeExceptionsSubscriptionRequest
  ) extends zio.aws.securitylake.model.CreateDatalakeExceptionsSubscriptionRequest.ReadOnly {
    override val notificationEndpoint: SafeString =
      zio.aws.securitylake.model.primitives
        .SafeString(impl.notificationEndpoint())
    override val subscriptionProtocol
        : zio.aws.securitylake.model.SubscriptionProtocolType =
      zio.aws.securitylake.model.SubscriptionProtocolType
        .wrap(impl.subscriptionProtocol())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateDatalakeExceptionsSubscriptionRequest
  ): zio.aws.securitylake.model.CreateDatalakeExceptionsSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
