package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.RoleArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDatalakeRequest(
    configurations: Optional[Map[
      zio.aws.securitylake.model.Region,
      zio.aws.securitylake.model.LakeConfigurationRequest
    ]] = Optional.Absent,
    enableAll: Optional[Boolean] = Optional.Absent,
    metaStoreManagerRoleArn: Optional[RoleArn] = Optional.Absent,
    regions: Optional[Iterable[zio.aws.securitylake.model.Region]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateDatalakeRequest = {
    import CreateDatalakeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateDatalakeRequest
      .builder()
      .optionallyWith(
        configurations.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.configurationsWithStrings)
      .optionallyWith(enableAll.map(value => value: java.lang.Boolean))(
        _.enableAll
      )
      .optionallyWith(
        metaStoreManagerRoleArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.metaStoreManagerRoleArn)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.regionsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.CreateDatalakeRequest.ReadOnly =
    zio.aws.securitylake.model.CreateDatalakeRequest.wrap(buildAwsValue())
}
object CreateDatalakeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateDatalakeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CreateDatalakeRequest =
      zio.aws.securitylake.model.CreateDatalakeRequest(
        configurations.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        enableAll.map(value => value),
        metaStoreManagerRoleArn.map(value => value),
        regions.map(value => value)
      )
    def configurations: Optional[Map[
      zio.aws.securitylake.model.Region,
      zio.aws.securitylake.model.LakeConfigurationRequest.ReadOnly
    ]]
    def enableAll: Optional[Boolean]
    def metaStoreManagerRoleArn: Optional[RoleArn]
    def regions: Optional[List[zio.aws.securitylake.model.Region]]
    def getConfigurations: ZIO[Any, AwsError, Map[
      zio.aws.securitylake.model.Region,
      zio.aws.securitylake.model.LakeConfigurationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("configurations", configurations)
    def getEnableAll: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableAll", enableAll)
    def getMetaStoreManagerRoleArn: ZIO[Any, AwsError, RoleArn] = AwsError
      .unwrapOptionField("metaStoreManagerRoleArn", metaStoreManagerRoleArn)
    def getRegions
        : ZIO[Any, AwsError, List[zio.aws.securitylake.model.Region]] =
      AwsError.unwrapOptionField("regions", regions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateDatalakeRequest
  ) extends zio.aws.securitylake.model.CreateDatalakeRequest.ReadOnly {
    override val configurations: Optional[Map[
      zio.aws.securitylake.model.Region,
      zio.aws.securitylake.model.LakeConfigurationRequest.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.configurations())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securitylake.model.Region.wrap(
              key
            ) -> zio.aws.securitylake.model.LakeConfigurationRequest.wrap(value)
          })
          .toMap
      )
    override val enableAll: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableAll())
      .map(value => value: Boolean)
    override val metaStoreManagerRoleArn: Optional[RoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metaStoreManagerRoleArn())
        .map(value => zio.aws.securitylake.model.primitives.RoleArn(value))
    override val regions: Optional[List[zio.aws.securitylake.model.Region]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.Region.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateDatalakeRequest
  ): zio.aws.securitylake.model.CreateDatalakeRequest.ReadOnly = new Wrapper(
    impl
  )
}
