package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{
  CreateSubscriberRequestSubscriberNameString,
  DescriptionString,
  SafeString,
  AwsAccountId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSubscriberRequest(
    accessTypes: Optional[Iterable[zio.aws.securitylake.model.AccessType]] =
      Optional.Absent,
    accountId: AwsAccountId,
    externalId: SafeString,
    sourceTypes: Iterable[zio.aws.securitylake.model.SourceType],
    subscriberDescription: Optional[DescriptionString] = Optional.Absent,
    subscriberName: CreateSubscriberRequestSubscriberNameString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateSubscriberRequest = {
    import CreateSubscriberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateSubscriberRequest
      .builder()
      .optionallyWith(
        accessTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.accessTypesWithStrings)
      .accountId(AwsAccountId.unwrap(accountId): java.lang.String)
      .externalId(SafeString.unwrap(externalId): java.lang.String)
      .sourceTypes(sourceTypes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        subscriberDescription.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.subscriberDescription)
      .subscriberName(
        CreateSubscriberRequestSubscriberNameString.unwrap(
          subscriberName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.CreateSubscriberRequest.ReadOnly =
    zio.aws.securitylake.model.CreateSubscriberRequest.wrap(buildAwsValue())
}
object CreateSubscriberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateSubscriberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CreateSubscriberRequest =
      zio.aws.securitylake.model.CreateSubscriberRequest(
        accessTypes.map(value => value),
        accountId,
        externalId,
        sourceTypes.map { item =>
          item.asEditable
        },
        subscriberDescription.map(value => value),
        subscriberName
      )
    def accessTypes: Optional[List[zio.aws.securitylake.model.AccessType]]
    def accountId: AwsAccountId
    def externalId: SafeString
    def sourceTypes: List[zio.aws.securitylake.model.SourceType.ReadOnly]
    def subscriberDescription: Optional[DescriptionString]
    def subscriberName: CreateSubscriberRequestSubscriberNameString
    def getAccessTypes
        : ZIO[Any, AwsError, List[zio.aws.securitylake.model.AccessType]] =
      AwsError.unwrapOptionField("accessTypes", accessTypes)
    def getAccountId: ZIO[Any, Nothing, AwsAccountId] = ZIO.succeed(accountId)
    def getExternalId: ZIO[Any, Nothing, SafeString] = ZIO.succeed(externalId)
    def getSourceTypes: ZIO[Any, Nothing, List[
      zio.aws.securitylake.model.SourceType.ReadOnly
    ]] = ZIO.succeed(sourceTypes)
    def getSubscriberDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("subscriberDescription", subscriberDescription)
    def getSubscriberName
        : ZIO[Any, Nothing, CreateSubscriberRequestSubscriberNameString] =
      ZIO.succeed(subscriberName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateSubscriberRequest
  ) extends zio.aws.securitylake.model.CreateSubscriberRequest.ReadOnly {
    override val accessTypes
        : Optional[List[zio.aws.securitylake.model.AccessType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.AccessType.wrap(item)
          }.toList
        )
    override val accountId: AwsAccountId =
      zio.aws.securitylake.model.primitives.AwsAccountId(impl.accountId())
    override val externalId: SafeString =
      zio.aws.securitylake.model.primitives.SafeString(impl.externalId())
    override val sourceTypes
        : List[zio.aws.securitylake.model.SourceType.ReadOnly] = impl
      .sourceTypes()
      .asScala
      .map { item =>
        zio.aws.securitylake.model.SourceType.wrap(item)
      }
      .toList
    override val subscriberDescription: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriberDescription())
        .map(value =>
          zio.aws.securitylake.model.primitives.DescriptionString(value)
        )
    override val subscriberName: CreateSubscriberRequestSubscriberNameString =
      zio.aws.securitylake.model.primitives
        .CreateSubscriberRequestSubscriberNameString(impl.subscriberName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateSubscriberRequest
  ): zio.aws.securitylake.model.CreateSubscriberRequest.ReadOnly = new Wrapper(
    impl
  )
}
