package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{
  RoleArn,
  ResourceShareName,
  S3BucketArn,
  SnsTopicArn,
  UUID,
  ResourceShareArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSubscriberResponse(
    resourceShareArn: Optional[ResourceShareArn] = Optional.Absent,
    resourceShareName: Optional[ResourceShareName] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    s3BucketArn: Optional[S3BucketArn] = Optional.Absent,
    snsArn: Optional[SnsTopicArn] = Optional.Absent,
    subscriptionId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateSubscriberResponse = {
    import CreateSubscriberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateSubscriberResponse
      .builder()
      .optionallyWith(
        resourceShareArn.map(value =>
          ResourceShareArn.unwrap(value): java.lang.String
        )
      )(_.resourceShareArn)
      .optionallyWith(
        resourceShareName.map(value =>
          ResourceShareName.unwrap(value): java.lang.String
        )
      )(_.resourceShareName)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        s3BucketArn.map(value => S3BucketArn.unwrap(value): java.lang.String)
      )(_.s3BucketArn)
      .optionallyWith(
        snsArn.map(value => SnsTopicArn.unwrap(value): java.lang.String)
      )(_.snsArn)
      .subscriptionId(UUID.unwrap(subscriptionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.CreateSubscriberResponse.ReadOnly =
    zio.aws.securitylake.model.CreateSubscriberResponse.wrap(buildAwsValue())
}
object CreateSubscriberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateSubscriberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CreateSubscriberResponse =
      zio.aws.securitylake.model.CreateSubscriberResponse(
        resourceShareArn.map(value => value),
        resourceShareName.map(value => value),
        roleArn.map(value => value),
        s3BucketArn.map(value => value),
        snsArn.map(value => value),
        subscriptionId
      )
    def resourceShareArn: Optional[ResourceShareArn]
    def resourceShareName: Optional[ResourceShareName]
    def roleArn: Optional[RoleArn]
    def s3BucketArn: Optional[S3BucketArn]
    def snsArn: Optional[SnsTopicArn]
    def subscriptionId: UUID
    def getResourceShareArn: ZIO[Any, AwsError, ResourceShareArn] =
      AwsError.unwrapOptionField("resourceShareArn", resourceShareArn)
    def getResourceShareName: ZIO[Any, AwsError, ResourceShareName] =
      AwsError.unwrapOptionField("resourceShareName", resourceShareName)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getS3BucketArn: ZIO[Any, AwsError, S3BucketArn] =
      AwsError.unwrapOptionField("s3BucketArn", s3BucketArn)
    def getSnsArn: ZIO[Any, AwsError, SnsTopicArn] =
      AwsError.unwrapOptionField("snsArn", snsArn)
    def getSubscriptionId: ZIO[Any, Nothing, UUID] = ZIO.succeed(subscriptionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateSubscriberResponse
  ) extends zio.aws.securitylake.model.CreateSubscriberResponse.ReadOnly {
    override val resourceShareArn: Optional[ResourceShareArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareArn())
        .map(value =>
          zio.aws.securitylake.model.primitives.ResourceShareArn(value)
        )
    override val resourceShareName: Optional[ResourceShareName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareName())
        .map(value =>
          zio.aws.securitylake.model.primitives.ResourceShareName(value)
        )
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.securitylake.model.primitives.RoleArn(value))
    override val s3BucketArn: Optional[S3BucketArn] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketArn())
      .map(value => zio.aws.securitylake.model.primitives.S3BucketArn(value))
    override val snsArn: Optional[SnsTopicArn] = zio.aws.core.internal
      .optionalFromNullable(impl.snsArn())
      .map(value => zio.aws.securitylake.model.primitives.SnsTopicArn(value))
    override val subscriptionId: UUID =
      zio.aws.securitylake.model.primitives.UUID(impl.subscriptionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateSubscriberResponse
  ): zio.aws.securitylake.model.CreateSubscriberResponse.ReadOnly = new Wrapper(
    impl
  )
}
