package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteCustomLogSourceRequest(customSourceName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceRequest = {
    import DeleteCustomLogSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceRequest
      .builder()
      .customSourceName(customSourceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.DeleteCustomLogSourceRequest.ReadOnly =
    zio.aws.securitylake.model.DeleteCustomLogSourceRequest
      .wrap(buildAwsValue())
}
object DeleteCustomLogSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DeleteCustomLogSourceRequest =
      zio.aws.securitylake.model.DeleteCustomLogSourceRequest(customSourceName)
    def customSourceName: String
    def getCustomSourceName: ZIO[Any, Nothing, String] =
      ZIO.succeed(customSourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceRequest
  ) extends zio.aws.securitylake.model.DeleteCustomLogSourceRequest.ReadOnly {
    override val customSourceName: String = impl.customSourceName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceRequest
  ): zio.aws.securitylake.model.DeleteCustomLogSourceRequest.ReadOnly =
    new Wrapper(impl)
}
