package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.SafeString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDatalakeDelegatedAdminRequest(account: SafeString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DeleteDatalakeDelegatedAdminRequest = {
    import DeleteDatalakeDelegatedAdminRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DeleteDatalakeDelegatedAdminRequest
      .builder()
      .account(SafeString.unwrap(account): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.DeleteDatalakeDelegatedAdminRequest.ReadOnly =
    zio.aws.securitylake.model.DeleteDatalakeDelegatedAdminRequest
      .wrap(buildAwsValue())
}
object DeleteDatalakeDelegatedAdminRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DeleteDatalakeDelegatedAdminRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.DeleteDatalakeDelegatedAdminRequest =
      zio.aws.securitylake.model.DeleteDatalakeDelegatedAdminRequest(account)
    def account: SafeString
    def getAccount: ZIO[Any, Nothing, SafeString] = ZIO.succeed(account)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteDatalakeDelegatedAdminRequest
  ) extends zio.aws.securitylake.model.DeleteDatalakeDelegatedAdminRequest.ReadOnly {
    override val account: SafeString =
      zio.aws.securitylake.model.primitives.SafeString(impl.account())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteDatalakeDelegatedAdminRequest
  ): zio.aws.securitylake.model.DeleteDatalakeDelegatedAdminRequest.ReadOnly =
    new Wrapper(impl)
}
