package zio.aws.securitylake.model
import scala.jdk.CollectionConverters.*
sealed trait EndpointProtocol {
  def unwrap
      : software.amazon.awssdk.services.securitylake.model.EndpointProtocol
}
object EndpointProtocol {
  def wrap(
      value: software.amazon.awssdk.services.securitylake.model.EndpointProtocol
  ): zio.aws.securitylake.model.EndpointProtocol = value match {
    case software.amazon.awssdk.services.securitylake.model.EndpointProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securitylake.model.EndpointProtocol.HTTPS =>
      val r = HTTPS
      r
    case software.amazon.awssdk.services.securitylake.model.EndpointProtocol.SQS =>
      val r = SQS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securitylake.model.EndpointProtocol {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.EndpointProtocol =
      software.amazon.awssdk.services.securitylake.model.EndpointProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTPS extends zio.aws.securitylake.model.EndpointProtocol {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.EndpointProtocol =
      software.amazon.awssdk.services.securitylake.model.EndpointProtocol.HTTPS
  }
  case object SQS extends zio.aws.securitylake.model.EndpointProtocol {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.EndpointProtocol =
      software.amazon.awssdk.services.securitylake.model.EndpointProtocol.SQS
  }
}
