package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{
  SyntheticTimestamp_date_time,
  SafeString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Failures(
    exceptionMessage: SafeString,
    remediation: SafeString,
    timestamp: SyntheticTimestamp_date_time
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.Failures = {
    import Failures.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.Failures
      .builder()
      .exceptionMessage(SafeString.unwrap(exceptionMessage): java.lang.String)
      .remediation(SafeString.unwrap(remediation): java.lang.String)
      .timestamp(SyntheticTimestamp_date_time.unwrap(timestamp): Instant)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.Failures.ReadOnly =
    zio.aws.securitylake.model.Failures.wrap(buildAwsValue())
}
object Failures {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.Failures
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.Failures =
      zio.aws.securitylake.model
        .Failures(exceptionMessage, remediation, timestamp)
    def exceptionMessage: SafeString
    def remediation: SafeString
    def timestamp: SyntheticTimestamp_date_time
    def getExceptionMessage: ZIO[Any, Nothing, SafeString] =
      ZIO.succeed(exceptionMessage)
    def getRemediation: ZIO[Any, Nothing, SafeString] = ZIO.succeed(remediation)
    def getTimestamp: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.Failures
  ) extends zio.aws.securitylake.model.Failures.ReadOnly {
    override val exceptionMessage: SafeString =
      zio.aws.securitylake.model.primitives.SafeString(impl.exceptionMessage())
    override val remediation: SafeString =
      zio.aws.securitylake.model.primitives.SafeString(impl.remediation())
    override val timestamp: SyntheticTimestamp_date_time =
      zio.aws.securitylake.model.primitives
        .SyntheticTimestamp_date_time(impl.timestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.Failures
  ): zio.aws.securitylake.model.Failures.ReadOnly = new Wrapper(impl)
}
