package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.SafeString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FailuresResponse(
    failures: Optional[Iterable[zio.aws.securitylake.model.Failures]] =
      Optional.Absent,
    region: Optional[SafeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.FailuresResponse = {
    import FailuresResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.FailuresResponse
      .builder()
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .optionallyWith(
        region.map(value => SafeString.unwrap(value): java.lang.String)
      )(_.region)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.FailuresResponse.ReadOnly =
    zio.aws.securitylake.model.FailuresResponse.wrap(buildAwsValue())
}
object FailuresResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.FailuresResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.FailuresResponse =
      zio.aws.securitylake.model.FailuresResponse(
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        region.map(value => value)
      )
    def failures: Optional[List[zio.aws.securitylake.model.Failures.ReadOnly]]
    def region: Optional[SafeString]
    def getFailures: ZIO[Any, AwsError, List[
      zio.aws.securitylake.model.Failures.ReadOnly
    ]] = AwsError.unwrapOptionField("failures", failures)
    def getRegion: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.FailuresResponse
  ) extends zio.aws.securitylake.model.FailuresResponse.ReadOnly {
    override val failures
        : Optional[List[zio.aws.securitylake.model.Failures.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.Failures.wrap(item)
          }.toList
        )
    override val region: Optional[SafeString] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.FailuresResponse
  ): zio.aws.securitylake.model.FailuresResponse.ReadOnly = new Wrapper(impl)
}
