package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDatalakeResponse(
    configurations: Map[
      zio.aws.securitylake.model.Region,
      zio.aws.securitylake.model.LakeConfigurationResponse
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.GetDatalakeResponse = {
    import GetDatalakeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.GetDatalakeResponse
      .builder()
      .configurationsWithStrings(
        configurations
          .map({ case (key, value) =>
            key.unwrap.toString -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.GetDatalakeResponse.ReadOnly =
    zio.aws.securitylake.model.GetDatalakeResponse.wrap(buildAwsValue())
}
object GetDatalakeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.GetDatalakeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.GetDatalakeResponse =
      zio.aws.securitylake.model.GetDatalakeResponse(configurations.map({
        case (key, value) =>
          key -> value.asEditable
      }))
    def configurations: Map[
      zio.aws.securitylake.model.Region,
      zio.aws.securitylake.model.LakeConfigurationResponse.ReadOnly
    ]
    def getConfigurations: ZIO[Any, Nothing, Map[
      zio.aws.securitylake.model.Region,
      zio.aws.securitylake.model.LakeConfigurationResponse.ReadOnly
    ]] = ZIO.succeed(configurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.GetDatalakeResponse
  ) extends zio.aws.securitylake.model.GetDatalakeResponse.ReadOnly {
    override val configurations: Map[
      zio.aws.securitylake.model.Region,
      zio.aws.securitylake.model.LakeConfigurationResponse.ReadOnly
    ] = impl
      .configurations()
      .asScala
      .map({ case (key, value) =>
        zio.aws.securitylake.model.Region.wrap(
          key
        ) -> zio.aws.securitylake.model.LakeConfigurationResponse.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.GetDatalakeResponse
  ): zio.aws.securitylake.model.GetDatalakeResponse.ReadOnly = new Wrapper(impl)
}
