package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{S3BucketArn, RoleArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LakeConfigurationResponse(
    encryptionKey: Optional[String] = Optional.Absent,
    replicationDestinationRegions: Optional[
      Iterable[zio.aws.securitylake.model.Region]
    ] = Optional.Absent,
    replicationRoleArn: Optional[RoleArn] = Optional.Absent,
    retentionSettings: Optional[
      Iterable[zio.aws.securitylake.model.RetentionSetting]
    ] = Optional.Absent,
    s3BucketArn: Optional[S3BucketArn] = Optional.Absent,
    status: Optional[zio.aws.securitylake.model.SettingsStatus] =
      Optional.Absent,
    tagsMap: Optional[Map[String, String]] = Optional.Absent,
    updateStatus: Optional[zio.aws.securitylake.model.UpdateStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.LakeConfigurationResponse = {
    import LakeConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.LakeConfigurationResponse
      .builder()
      .optionallyWith(encryptionKey.map(value => value: java.lang.String))(
        _.encryptionKey
      )
      .optionallyWith(
        replicationDestinationRegions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.replicationDestinationRegionsWithStrings)
      .optionallyWith(
        replicationRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.replicationRoleArn)
      .optionallyWith(
        retentionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.retentionSettings)
      .optionallyWith(
        s3BucketArn.map(value => S3BucketArn.unwrap(value): java.lang.String)
      )(_.s3BucketArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tagsMap.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tagsMap)
      .optionallyWith(updateStatus.map(value => value.buildAwsValue()))(
        _.updateStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.LakeConfigurationResponse.ReadOnly =
    zio.aws.securitylake.model.LakeConfigurationResponse.wrap(buildAwsValue())
}
object LakeConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.LakeConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.LakeConfigurationResponse =
      zio.aws.securitylake.model.LakeConfigurationResponse(
        encryptionKey.map(value => value),
        replicationDestinationRegions.map(value => value),
        replicationRoleArn.map(value => value),
        retentionSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        s3BucketArn.map(value => value),
        status.map(value => value),
        tagsMap.map(value => value),
        updateStatus.map(value => value.asEditable)
      )
    def encryptionKey: Optional[String]
    def replicationDestinationRegions
        : Optional[List[zio.aws.securitylake.model.Region]]
    def replicationRoleArn: Optional[RoleArn]
    def retentionSettings
        : Optional[List[zio.aws.securitylake.model.RetentionSetting.ReadOnly]]
    def s3BucketArn: Optional[S3BucketArn]
    def status: Optional[zio.aws.securitylake.model.SettingsStatus]
    def tagsMap: Optional[Map[String, String]]
    def updateStatus: Optional[zio.aws.securitylake.model.UpdateStatus.ReadOnly]
    def getEncryptionKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getReplicationDestinationRegions
        : ZIO[Any, AwsError, List[zio.aws.securitylake.model.Region]] =
      AwsError.unwrapOptionField(
        "replicationDestinationRegions",
        replicationDestinationRegions
      )
    def getReplicationRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("replicationRoleArn", replicationRoleArn)
    def getRetentionSettings: ZIO[Any, AwsError, List[
      zio.aws.securitylake.model.RetentionSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("retentionSettings", retentionSettings)
    def getS3BucketArn: ZIO[Any, AwsError, S3BucketArn] =
      AwsError.unwrapOptionField("s3BucketArn", s3BucketArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.securitylake.model.SettingsStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTagsMap: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tagsMap", tagsMap)
    def getUpdateStatus
        : ZIO[Any, AwsError, zio.aws.securitylake.model.UpdateStatus.ReadOnly] =
      AwsError.unwrapOptionField("updateStatus", updateStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.LakeConfigurationResponse
  ) extends zio.aws.securitylake.model.LakeConfigurationResponse.ReadOnly {
    override val encryptionKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKey())
      .map(value => value: String)
    override val replicationDestinationRegions
        : Optional[List[zio.aws.securitylake.model.Region]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationDestinationRegions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.Region.wrap(item)
          }.toList
        )
    override val replicationRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationRoleArn())
      .map(value => zio.aws.securitylake.model.primitives.RoleArn(value))
    override val retentionSettings
        : Optional[List[zio.aws.securitylake.model.RetentionSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.RetentionSetting.wrap(item)
          }.toList
        )
    override val s3BucketArn: Optional[S3BucketArn] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketArn())
      .map(value => zio.aws.securitylake.model.primitives.S3BucketArn(value))
    override val status: Optional[zio.aws.securitylake.model.SettingsStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.securitylake.model.SettingsStatus.wrap(value))
    override val tagsMap: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagsMap())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val updateStatus
        : Optional[zio.aws.securitylake.model.UpdateStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateStatus())
        .map(value => zio.aws.securitylake.model.UpdateStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.LakeConfigurationResponse
  ): zio.aws.securitylake.model.LakeConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
