package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.SafeString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDatalakeExceptionsResponse(
    nextToken: Optional[SafeString] = Optional.Absent,
    nonRetryableFailures: Iterable[zio.aws.securitylake.model.FailuresResponse]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsResponse = {
    import ListDatalakeExceptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => SafeString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .nonRetryableFailures(nonRetryableFailures.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.ListDatalakeExceptionsResponse.ReadOnly =
    zio.aws.securitylake.model.ListDatalakeExceptionsResponse
      .wrap(buildAwsValue())
}
object ListDatalakeExceptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.ListDatalakeExceptionsResponse =
      zio.aws.securitylake.model.ListDatalakeExceptionsResponse(
        nextToken.map(value => value),
        nonRetryableFailures.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[SafeString]
    def nonRetryableFailures
        : List[zio.aws.securitylake.model.FailuresResponse.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNonRetryableFailures: ZIO[Any, Nothing, List[
      zio.aws.securitylake.model.FailuresResponse.ReadOnly
    ]] = ZIO.succeed(nonRetryableFailures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsResponse
  ) extends zio.aws.securitylake.model.ListDatalakeExceptionsResponse.ReadOnly {
    override val nextToken: Optional[SafeString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
    override val nonRetryableFailures
        : List[zio.aws.securitylake.model.FailuresResponse.ReadOnly] = impl
      .nonRetryableFailures()
      .asScala
      .map { item =>
        zio.aws.securitylake.model.FailuresResponse.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsResponse
  ): zio.aws.securitylake.model.ListDatalakeExceptionsResponse.ReadOnly =
    new Wrapper(impl)
}
