package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{Integer, SafeString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListLogSourcesRequest(
    inputOrder: Optional[Iterable[zio.aws.securitylake.model.Dimension]] =
      Optional.Absent,
    listAllDimensions: Optional[Map[String, Map[String, Iterable[String]]]] =
      Optional.Absent,
    listSingleDimension: Optional[Iterable[SafeString]] = Optional.Absent,
    listTwoDimensions: Optional[Map[String, Iterable[String]]] =
      Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[SafeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest = {
    import ListLogSourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest
      .builder()
      .optionallyWith(
        inputOrder.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.inputOrderWithStrings)
      .optionallyWith(
        listAllDimensions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value
                .map({ case (key, value) =>
                  (key: java.lang.String) -> value.map { item =>
                    item: java.lang.String
                  }.asJavaCollection
                })
                .asJava
            })
            .asJava
        )
      )(_.listAllDimensions)
      .optionallyWith(
        listSingleDimension.map(value =>
          value.map { item =>
            SafeString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.listSingleDimension)
      .optionallyWith(
        listTwoDimensions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.listTwoDimensions)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => SafeString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.ListLogSourcesRequest.ReadOnly =
    zio.aws.securitylake.model.ListLogSourcesRequest.wrap(buildAwsValue())
}
object ListLogSourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.ListLogSourcesRequest =
      zio.aws.securitylake.model.ListLogSourcesRequest(
        inputOrder.map(value => value),
        listAllDimensions.map(value => value),
        listSingleDimension.map(value => value),
        listTwoDimensions.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def inputOrder: Optional[List[zio.aws.securitylake.model.Dimension]]
    def listAllDimensions: Optional[Map[String, Map[String, List[String]]]]
    def listSingleDimension: Optional[List[SafeString]]
    def listTwoDimensions: Optional[Map[String, List[String]]]
    def maxResults: Optional[Integer]
    def nextToken: Optional[SafeString]
    def getInputOrder
        : ZIO[Any, AwsError, List[zio.aws.securitylake.model.Dimension]] =
      AwsError.unwrapOptionField("inputOrder", inputOrder)
    def getListAllDimensions
        : ZIO[Any, AwsError, Map[String, Map[String, List[String]]]] =
      AwsError.unwrapOptionField("listAllDimensions", listAllDimensions)
    def getListSingleDimension: ZIO[Any, AwsError, List[SafeString]] =
      AwsError.unwrapOptionField("listSingleDimension", listSingleDimension)
    def getListTwoDimensions: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("listTwoDimensions", listTwoDimensions)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest
  ) extends zio.aws.securitylake.model.ListLogSourcesRequest.ReadOnly {
    override val inputOrder
        : Optional[List[zio.aws.securitylake.model.Dimension]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputOrder())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.Dimension.wrap(item)
          }.toList
        )
    override val listAllDimensions
        : Optional[Map[String, Map[String, List[String]]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listAllDimensions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala
                .map({ case (key, value) =>
                  (key: String) -> value.asScala.map { item =>
                    item: String
                  }.toList
                })
                .toMap
            })
            .toMap
        )
    override val listSingleDimension: Optional[List[SafeString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listSingleDimension())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.primitives.SafeString(item)
          }.toList
        )
    override val listTwoDimensions: Optional[Map[String, List[String]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listTwoDimensions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala.map { item =>
                item: String
              }.toList
            })
            .toMap
        )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[SafeString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest
  ): zio.aws.securitylake.model.ListLogSourcesRequest.ReadOnly = new Wrapper(
    impl
  )
}
