package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListLogSourcesResponse(
    nextToken: Optional[String] = Optional.Absent,
    regionSourceTypesAccountsList: Iterable[
      Map[String, Map[String, Iterable[String]]]
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse = {
    import ListLogSourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .regionSourceTypesAccountsList(regionSourceTypesAccountsList.map { item =>
        item
          .map({ case (key, value) =>
            (key: java.lang.String) -> value
              .map({ case (key, value) =>
                (key: java.lang.String) -> value.map { item =>
                  item: java.lang.String
                }.asJavaCollection
              })
              .asJava
          })
          .asJava
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.ListLogSourcesResponse.ReadOnly =
    zio.aws.securitylake.model.ListLogSourcesResponse.wrap(buildAwsValue())
}
object ListLogSourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.ListLogSourcesResponse =
      zio.aws.securitylake.model.ListLogSourcesResponse(
        nextToken.map(value => value),
        regionSourceTypesAccountsList
      )
    def nextToken: Optional[String]
    def regionSourceTypesAccountsList
        : List[Map[String, Map[String, List[String]]]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRegionSourceTypesAccountsList
        : ZIO[Any, Nothing, List[Map[String, Map[String, List[String]]]]] =
      ZIO.succeed(regionSourceTypesAccountsList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse
  ) extends zio.aws.securitylake.model.ListLogSourcesResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val regionSourceTypesAccountsList
        : List[Map[String, Map[String, List[String]]]] = impl
      .regionSourceTypesAccountsList()
      .asScala
      .map { item =>
        item.asScala
          .map({ case (key, value) =>
            (key: String) -> value.asScala
              .map({ case (key, value) =>
                (key: String) -> value.asScala.map { item =>
                  item: String
                }.toList
              })
              .toMap
          })
          .toMap
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse
  ): zio.aws.securitylake.model.ListLogSourcesResponse.ReadOnly = new Wrapper(
    impl
  )
}
