package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSubscribersResponse(
    nextToken: Optional[String] = Optional.Absent,
    subscribers: Iterable[zio.aws.securitylake.model.SubscriberResource]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse = {
    import ListSubscribersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .subscribers(subscribers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.ListSubscribersResponse.ReadOnly =
    zio.aws.securitylake.model.ListSubscribersResponse.wrap(buildAwsValue())
}
object ListSubscribersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.ListSubscribersResponse =
      zio.aws.securitylake.model.ListSubscribersResponse(
        nextToken.map(value => value),
        subscribers.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[String]
    def subscribers
        : List[zio.aws.securitylake.model.SubscriberResource.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSubscribers: ZIO[Any, Nothing, List[
      zio.aws.securitylake.model.SubscriberResource.ReadOnly
    ]] = ZIO.succeed(subscribers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse
  ) extends zio.aws.securitylake.model.ListSubscribersResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val subscribers
        : List[zio.aws.securitylake.model.SubscriberResource.ReadOnly] = impl
      .subscribers()
      .asScala
      .map { item =>
        zio.aws.securitylake.model.SubscriberResource.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse
  ): zio.aws.securitylake.model.ListSubscribersResponse.ReadOnly = new Wrapper(
    impl
  )
}
