package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class LogsStatus(
    healthStatus: zio.aws.securitylake.model.SourceStatus,
    pathToLogs: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.LogsStatus = {
    import LogsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.LogsStatus
      .builder()
      .healthStatus(healthStatus.unwrap)
      .pathToLogs(pathToLogs: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.LogsStatus.ReadOnly =
    zio.aws.securitylake.model.LogsStatus.wrap(buildAwsValue())
}
object LogsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.LogsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.LogsStatus =
      zio.aws.securitylake.model.LogsStatus(healthStatus, pathToLogs)
    def healthStatus: zio.aws.securitylake.model.SourceStatus
    def pathToLogs: String
    def getHealthStatus
        : ZIO[Any, Nothing, zio.aws.securitylake.model.SourceStatus] =
      ZIO.succeed(healthStatus)
    def getPathToLogs: ZIO[Any, Nothing, String] = ZIO.succeed(pathToLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.LogsStatus
  ) extends zio.aws.securitylake.model.LogsStatus.ReadOnly {
    override val healthStatus: zio.aws.securitylake.model.SourceStatus =
      zio.aws.securitylake.model.SourceStatus.wrap(impl.healthStatus())
    override val pathToLogs: String = impl.pathToLogs(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.LogsStatus
  ): zio.aws.securitylake.model.LogsStatus.ReadOnly = new Wrapper(impl)
}
