package zio.aws.securitylake.model
import scala.jdk.CollectionConverters.*
sealed trait OcsfEventClass {
  def unwrap: software.amazon.awssdk.services.securitylake.model.OcsfEventClass
}
object OcsfEventClass {
  def wrap(
      value: software.amazon.awssdk.services.securitylake.model.OcsfEventClass
  ): zio.aws.securitylake.model.OcsfEventClass = value match {
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.ACCESS_ACTIVITY =>
      val r = ACCESS_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.FILE_ACTIVITY =>
      val r = FILE_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.KERNEL_ACTIVITY =>
      val r = KERNEL_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.KERNEL_EXTENSION =>
      val r = KERNEL_EXTENSION
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.MEMORY_ACTIVITY =>
      val r = MEMORY_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.MODULE_ACTIVITY =>
      val r = MODULE_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.PROCESS_ACTIVITY =>
      val r = PROCESS_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.REGISTRY_KEY_ACTIVITY =>
      val r = REGISTRY_KEY_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.REGISTRY_VALUE_ACTIVITY =>
      val r = REGISTRY_VALUE_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.RESOURCE_ACTIVITY =>
      val r = RESOURCE_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.SCHEDULED_JOB_ACTIVITY =>
      val r = SCHEDULED_JOB_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.SECURITY_FINDING =>
      val r = SECURITY_FINDING
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.ACCOUNT_CHANGE =>
      val r = ACCOUNT_CHANGE
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.AUTHENTICATION =>
      val r = AUTHENTICATION
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.AUTHORIZATION =>
      val r = AUTHORIZATION
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.ENTITY_MANAGEMENT_AUDIT =>
      val r = ENTITY_MANAGEMENT_AUDIT
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.DHCP_ACTIVITY =>
      val r = DHCP_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.NETWORK_ACTIVITY =>
      val r = NETWORK_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.DNS_ACTIVITY =>
      val r = DNS_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.FTP_ACTIVITY =>
      val r = FTP_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.HTTP_ACTIVITY =>
      val r = HTTP_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.RDP_ACTIVITY =>
      val r = RDP_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.SMB_ACTIVITY =>
      val r = SMB_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.SSH_ACTIVITY =>
      val r = SSH_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.CLOUD_API =>
      val r = CLOUD_API
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.CONTAINER_LIFECYCLE =>
      val r = CONTAINER_LIFECYCLE
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.DATABASE_LIFECYCLE =>
      val r = DATABASE_LIFECYCLE
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.CONFIG_STATE =>
      val r = CONFIG_STATE
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.CLOUD_STORAGE =>
      val r = CLOUD_STORAGE
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.INVENTORY_INFO =>
      val r = INVENTORY_INFO
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.RFB_ACTIVITY =>
      val r = RFB_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.SMTP_ACTIVITY =>
      val r = SMTP_ACTIVITY
      r
    case software.amazon.awssdk.services.securitylake.model.OcsfEventClass.VIRTUAL_MACHINE_ACTIVITY =>
      val r = VIRTUAL_MACHINE_ACTIVITY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCESS_ACTIVITY
      extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.ACCESS_ACTIVITY
  }
  case object FILE_ACTIVITY extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.FILE_ACTIVITY
  }
  case object KERNEL_ACTIVITY
      extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.KERNEL_ACTIVITY
  }
  case object KERNEL_EXTENSION
      extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.KERNEL_EXTENSION
  }
  case object MEMORY_ACTIVITY
      extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.MEMORY_ACTIVITY
  }
  case object MODULE_ACTIVITY
      extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.MODULE_ACTIVITY
  }
  case object PROCESS_ACTIVITY
      extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.PROCESS_ACTIVITY
  }
  case object REGISTRY_KEY_ACTIVITY
      extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.REGISTRY_KEY_ACTIVITY
  }
  case object REGISTRY_VALUE_ACTIVITY
      extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.REGISTRY_VALUE_ACTIVITY
  }
  case object RESOURCE_ACTIVITY
      extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.RESOURCE_ACTIVITY
  }
  case object SCHEDULED_JOB_ACTIVITY
      extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.SCHEDULED_JOB_ACTIVITY
  }
  case object SECURITY_FINDING
      extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.SECURITY_FINDING
  }
  case object ACCOUNT_CHANGE extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.ACCOUNT_CHANGE
  }
  case object AUTHENTICATION extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.AUTHENTICATION
  }
  case object AUTHORIZATION extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.AUTHORIZATION
  }
  case object ENTITY_MANAGEMENT_AUDIT
      extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.ENTITY_MANAGEMENT_AUDIT
  }
  case object DHCP_ACTIVITY extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.DHCP_ACTIVITY
  }
  case object NETWORK_ACTIVITY
      extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.NETWORK_ACTIVITY
  }
  case object DNS_ACTIVITY extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.DNS_ACTIVITY
  }
  case object FTP_ACTIVITY extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.FTP_ACTIVITY
  }
  case object HTTP_ACTIVITY extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.HTTP_ACTIVITY
  }
  case object RDP_ACTIVITY extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.RDP_ACTIVITY
  }
  case object SMB_ACTIVITY extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.SMB_ACTIVITY
  }
  case object SSH_ACTIVITY extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.SSH_ACTIVITY
  }
  case object CLOUD_API extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.CLOUD_API
  }
  case object CONTAINER_LIFECYCLE
      extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.CONTAINER_LIFECYCLE
  }
  case object DATABASE_LIFECYCLE
      extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.DATABASE_LIFECYCLE
  }
  case object CONFIG_STATE extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.CONFIG_STATE
  }
  case object CLOUD_STORAGE extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.CLOUD_STORAGE
  }
  case object INVENTORY_INFO extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.INVENTORY_INFO
  }
  case object RFB_ACTIVITY extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.RFB_ACTIVITY
  }
  case object SMTP_ACTIVITY extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.SMTP_ACTIVITY
  }
  case object VIRTUAL_MACHINE_ACTIVITY
      extends zio.aws.securitylake.model.OcsfEventClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.OcsfEventClass =
      software.amazon.awssdk.services.securitylake.model.OcsfEventClass.VIRTUAL_MACHINE_ACTIVITY
  }
}
