package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.SafeString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ProtocolAndNotificationEndpoint(
    endpoint: Optional[SafeString] = Optional.Absent,
    protocol: Optional[SafeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.ProtocolAndNotificationEndpoint = {
    import ProtocolAndNotificationEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.ProtocolAndNotificationEndpoint
      .builder()
      .optionallyWith(
        endpoint.map(value => SafeString.unwrap(value): java.lang.String)
      )(_.endpoint)
      .optionallyWith(
        protocol.map(value => SafeString.unwrap(value): java.lang.String)
      )(_.protocol)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.ProtocolAndNotificationEndpoint.ReadOnly =
    zio.aws.securitylake.model.ProtocolAndNotificationEndpoint
      .wrap(buildAwsValue())
}
object ProtocolAndNotificationEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.ProtocolAndNotificationEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.ProtocolAndNotificationEndpoint =
      zio.aws.securitylake.model.ProtocolAndNotificationEndpoint(
        endpoint.map(value => value),
        protocol.map(value => value)
      )
    def endpoint: Optional[SafeString]
    def protocol: Optional[SafeString]
    def getEndpoint: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getProtocol: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("protocol", protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.ProtocolAndNotificationEndpoint
  ) extends zio.aws.securitylake.model.ProtocolAndNotificationEndpoint.ReadOnly {
    override val endpoint: Optional[SafeString] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
    override val protocol: Optional[SafeString] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.ProtocolAndNotificationEndpoint
  ): zio.aws.securitylake.model.ProtocolAndNotificationEndpoint.ReadOnly =
    new Wrapper(impl)
}
