package zio.aws.securitylake.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.securitylake.model.primitives.RetentionSettingRetentionPeriodInteger
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RetentionSetting(
    retentionPeriod: Optional[RetentionSettingRetentionPeriodInteger] =
      Optional.Absent,
    storageClass: Optional[zio.aws.securitylake.model.StorageClass] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.RetentionSetting = {
    import RetentionSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.RetentionSetting
      .builder()
      .optionallyWith(
        retentionPeriod.map(value =>
          RetentionSettingRetentionPeriodInteger.unwrap(value): Integer
        )
      )(_.retentionPeriod)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.RetentionSetting.ReadOnly =
    zio.aws.securitylake.model.RetentionSetting.wrap(buildAwsValue())
}
object RetentionSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.RetentionSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.RetentionSetting =
      zio.aws.securitylake.model.RetentionSetting(
        retentionPeriod.map(value => value),
        storageClass.map(value => value)
      )
    def retentionPeriod: Optional[RetentionSettingRetentionPeriodInteger]
    def storageClass: Optional[zio.aws.securitylake.model.StorageClass]
    def getRetentionPeriod
        : ZIO[Any, AwsError, RetentionSettingRetentionPeriodInteger] =
      AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.securitylake.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.RetentionSetting
  ) extends zio.aws.securitylake.model.RetentionSetting.ReadOnly {
    override val retentionPeriod
        : Optional[RetentionSettingRetentionPeriodInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionPeriod())
        .map(value =>
          zio.aws.securitylake.model.primitives
            .RetentionSettingRetentionPeriodInteger(value)
        )
    override val storageClass
        : Optional[zio.aws.securitylake.model.StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.securitylake.model.StorageClass.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.RetentionSetting
  ): zio.aws.securitylake.model.RetentionSetting.ReadOnly = new Wrapper(impl)
}
