package zio.aws.securitylake.model
import scala.jdk.CollectionConverters.*
sealed trait SettingsStatus {
  def unwrap: software.amazon.awssdk.services.securitylake.model.SettingsStatus
}
object SettingsStatus {
  def wrap(
      value: software.amazon.awssdk.services.securitylake.model.SettingsStatus
  ): zio.aws.securitylake.model.SettingsStatus = value match {
    case software.amazon.awssdk.services.securitylake.model.SettingsStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securitylake.model.SettingsStatus.INITIALIZED =>
      val r = INITIALIZED
      r
    case software.amazon.awssdk.services.securitylake.model.SettingsStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.securitylake.model.SettingsStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.securitylake.model.SettingsStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securitylake.model.SettingsStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SettingsStatus =
      software.amazon.awssdk.services.securitylake.model.SettingsStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object INITIALIZED extends zio.aws.securitylake.model.SettingsStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SettingsStatus =
      software.amazon.awssdk.services.securitylake.model.SettingsStatus.INITIALIZED
  }
  case object PENDING extends zio.aws.securitylake.model.SettingsStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SettingsStatus =
      software.amazon.awssdk.services.securitylake.model.SettingsStatus.PENDING
  }
  case object COMPLETED extends zio.aws.securitylake.model.SettingsStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SettingsStatus =
      software.amazon.awssdk.services.securitylake.model.SettingsStatus.COMPLETED
  }
  case object FAILED extends zio.aws.securitylake.model.SettingsStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SettingsStatus =
      software.amazon.awssdk.services.securitylake.model.SettingsStatus.FAILED
  }
}
