package zio.aws.securitylake.model
import scala.jdk.CollectionConverters.*
sealed trait SourceStatus {
  def unwrap: software.amazon.awssdk.services.securitylake.model.SourceStatus
}
object SourceStatus {
  def wrap(
      value: software.amazon.awssdk.services.securitylake.model.SourceStatus
  ): zio.aws.securitylake.model.SourceStatus = value match {
    case software.amazon.awssdk.services.securitylake.model.SourceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securitylake.model.SourceStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.securitylake.model.SourceStatus.DEACTIVATED =>
      val r = DEACTIVATED
      r
    case software.amazon.awssdk.services.securitylake.model.SourceStatus.PENDING =>
      val r = PENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securitylake.model.SourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SourceStatus =
      software.amazon.awssdk.services.securitylake.model.SourceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.securitylake.model.SourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SourceStatus =
      software.amazon.awssdk.services.securitylake.model.SourceStatus.ACTIVE
  }
  case object DEACTIVATED extends zio.aws.securitylake.model.SourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SourceStatus =
      software.amazon.awssdk.services.securitylake.model.SourceStatus.DEACTIVATED
  }
  case object PENDING extends zio.aws.securitylake.model.SourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SourceStatus =
      software.amazon.awssdk.services.securitylake.model.SourceStatus.PENDING
  }
}
