package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.CustomSourceType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SourceType(
    awsSourceType: Optional[zio.aws.securitylake.model.AwsLogSourceType] =
      Optional.Absent,
    customSourceType: Optional[CustomSourceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.SourceType = {
    import SourceType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.SourceType
      .builder()
      .optionallyWith(awsSourceType.map(value => value.unwrap))(_.awsSourceType)
      .optionallyWith(
        customSourceType.map(value =>
          CustomSourceType.unwrap(value): java.lang.String
        )
      )(_.customSourceType)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.SourceType.ReadOnly =
    zio.aws.securitylake.model.SourceType.wrap(buildAwsValue())
}
object SourceType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.SourceType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.SourceType =
      zio.aws.securitylake.model.SourceType(
        awsSourceType.map(value => value),
        customSourceType.map(value => value)
      )
    def awsSourceType: Optional[zio.aws.securitylake.model.AwsLogSourceType]
    def customSourceType: Optional[CustomSourceType]
    def getAwsSourceType
        : ZIO[Any, AwsError, zio.aws.securitylake.model.AwsLogSourceType] =
      AwsError.unwrapOptionField("awsSourceType", awsSourceType)
    def getCustomSourceType: ZIO[Any, AwsError, CustomSourceType] =
      AwsError.unwrapOptionField("customSourceType", customSourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.SourceType
  ) extends zio.aws.securitylake.model.SourceType.ReadOnly {
    override val awsSourceType
        : Optional[zio.aws.securitylake.model.AwsLogSourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsSourceType())
        .map(value => zio.aws.securitylake.model.AwsLogSourceType.wrap(value))
    override val customSourceType: Optional[CustomSourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customSourceType())
        .map(value =>
          zio.aws.securitylake.model.primitives.CustomSourceType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.SourceType
  ): zio.aws.securitylake.model.SourceType.ReadOnly = new Wrapper(impl)
}
