package zio.aws.securitylake.model
import scala.jdk.CollectionConverters.*
sealed trait StorageClass {
  def unwrap: software.amazon.awssdk.services.securitylake.model.StorageClass
}
object StorageClass {
  def wrap(
      value: software.amazon.awssdk.services.securitylake.model.StorageClass
  ): zio.aws.securitylake.model.StorageClass = value match {
    case software.amazon.awssdk.services.securitylake.model.StorageClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securitylake.model.StorageClass.STANDARD_IA =>
      val r = STANDARD_IA
      r
    case software.amazon.awssdk.services.securitylake.model.StorageClass.ONEZONE_IA =>
      val r = ONEZONE_IA
      r
    case software.amazon.awssdk.services.securitylake.model.StorageClass.INTELLIGENT_TIERING =>
      val r = INTELLIGENT_TIERING
      r
    case software.amazon.awssdk.services.securitylake.model.StorageClass.GLACIER_IR =>
      val r = GLACIER_IR
      r
    case software.amazon.awssdk.services.securitylake.model.StorageClass.GLACIER =>
      val r = GLACIER
      r
    case software.amazon.awssdk.services.securitylake.model.StorageClass.DEEP_ARCHIVE =>
      val r = DEEP_ARCHIVE
      r
    case software.amazon.awssdk.services.securitylake.model.StorageClass.EXPIRE =>
      val r = EXPIRE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securitylake.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.StorageClass =
      software.amazon.awssdk.services.securitylake.model.StorageClass.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD_IA extends zio.aws.securitylake.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.StorageClass =
      software.amazon.awssdk.services.securitylake.model.StorageClass.STANDARD_IA
  }
  case object ONEZONE_IA extends zio.aws.securitylake.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.StorageClass =
      software.amazon.awssdk.services.securitylake.model.StorageClass.ONEZONE_IA
  }
  case object INTELLIGENT_TIERING
      extends zio.aws.securitylake.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.StorageClass =
      software.amazon.awssdk.services.securitylake.model.StorageClass.INTELLIGENT_TIERING
  }
  case object GLACIER_IR extends zio.aws.securitylake.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.StorageClass =
      software.amazon.awssdk.services.securitylake.model.StorageClass.GLACIER_IR
  }
  case object GLACIER extends zio.aws.securitylake.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.StorageClass =
      software.amazon.awssdk.services.securitylake.model.StorageClass.GLACIER
  }
  case object DEEP_ARCHIVE extends zio.aws.securitylake.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.StorageClass =
      software.amazon.awssdk.services.securitylake.model.StorageClass.DEEP_ARCHIVE
  }
  case object EXPIRE extends zio.aws.securitylake.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.StorageClass =
      software.amazon.awssdk.services.securitylake.model.StorageClass.EXPIRE
  }
}
